/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.message;

import java.net.URI;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageDirection;
import won.protocol.message.WonMessageType;

public class WonMessageUtils {
    public static URI getParentEntityUri(WonMessage message) {
        URI parentURI = null;
        WonMessageDirection direction = message.getEnvelopeType();
        if (direction == WonMessageDirection.FROM_EXTERNAL) {
            parentURI = WonMessageUtils.getParentUriFromReceiverProperties(message);
        } else if (direction == WonMessageDirection.FROM_OWNER || direction == WonMessageDirection.FROM_SYSTEM) {
            parentURI = WonMessageUtils.getParentUriFromSenderProperties(message);
        }
        return parentURI;
    }

    public static URI getParentAtomUri(WonMessage message) {
        WonMessageDirection direction = message.getEnvelopeType();
        if (direction == WonMessageDirection.FROM_EXTERNAL) {
            return message.getRecipientAtomURI();
        }
        if (direction == WonMessageDirection.FROM_OWNER || direction == WonMessageDirection.FROM_SYSTEM) {
            return message.getSenderAtomURI();
        }
        throw new IllegalArgumentException("Unexpected message direction: " + (Object)((Object)direction));
    }

    private static URI getParentUriFromSenderProperties(WonMessage message) {
        URI parentURI = message.getSenderURI();
        if (parentURI == null) {
            parentURI = message.getSenderAtomURI();
        }
        if (parentURI == null) {
            parentURI = message.getSenderNodeURI();
        }
        return parentURI;
    }

    private static URI getParentUriFromReceiverProperties(WonMessage message) {
        URI parentURI = message.getRecipientURI();
        if (parentURI == null) {
            parentURI = message.getRecipientAtomURI();
        }
        if (parentURI == null) {
            parentURI = message.getRecipientNodeURI();
        }
        return parentURI;
    }

    public static URI getLocalIsResponseToURI(WonMessage message) {
        WonMessageType messageType = message.getMessageType();
        if (messageType == WonMessageType.SUCCESS_RESPONSE || messageType == WonMessageType.FAILURE_RESPONSE) {
            WonMessageDirection direction = message.getEnvelopeType();
            if (direction == WonMessageDirection.FROM_EXTERNAL) {
                return message.getIsRemoteResponseToMessageURI();
            }
            return message.getIsResponseToMessageURI();
        }
        return null;
    }
}

