/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.message;

import java.net.URI;
import org.apache.jena.rdf.model.Resource;
import won.protocol.vocabulary.WONMSG;

public enum WonMessageType {
    CREATE_ATOM(WONMSG.CreateMessage),
    REPLACE(WONMSG.ReplaceMessage),
    CONNECT(WONMSG.ConnectMessage),
    DEACTIVATE(WONMSG.DeactivateMessage),
    ACTIVATE(WONMSG.ActivateMessage),
    CLOSE(WONMSG.CloseMessage),
    DELETE(WONMSG.DeleteMessage),
    OPEN(WONMSG.OpenMessage),
    CONNECTION_MESSAGE(WONMSG.ConnectionMessage),
    ATOM_MESSAGE(WONMSG.AtomMessage),
    ATOM_HINT_MESSAGE(WONMSG.AtomHintMessage),
    SOCKET_HINT_MESSAGE(WONMSG.SocketHintMessage),
    HINT_FEEDBACK_MESSAGE(WONMSG.HintFeedbackMessage),
    HINT_NOTIFICATION(WONMSG.HintNotificationMessage),
    ATOM_CREATED_NOTIFICATION(WONMSG.AtomCreatedNotificationMessage),
    SUCCESS_RESPONSE(WONMSG.SuccessResponse),
    FAILURE_RESPONSE(WONMSG.FailureResponse),
    CHANGE_NOTIFICATION(WONMSG.ChangeNotificationMessage);

    private Resource resource;

    private WonMessageType(Resource resource) {
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public URI getURI() {
        return URI.create(this.getResource().getURI().toString());
    }

    public static WonMessageType getWonMessageType(URI uri) {
        return WonMessageType.getWonMessageType(WONMSG.toResource(uri));
    }

    public boolean isIdentifiedBy(URI uri) {
        if (uri == null) {
            return false;
        }
        return this.getResource().getURI().toString().equals(uri.toString());
    }

    public boolean causesConnectionStateChange() {
        return this == CLOSE || this == CONNECT || this == OPEN;
    }

    public boolean causesAtomStateChange() {
        return this == ACTIVATE || this == DEACTIVATE || this == REPLACE || this == DELETE;
    }

    public boolean causesNewConnection() {
        return this == CONNECT || this == SOCKET_HINT_MESSAGE;
    }

    public boolean isHintMessage() {
        return this == ATOM_HINT_MESSAGE || this == SOCKET_HINT_MESSAGE;
    }

    public static WonMessageType getWonMessageType(Resource resource) {
        if (WONMSG.CreateMessage.equals((Object)resource)) {
            return CREATE_ATOM;
        }
        if (WONMSG.ReplaceMessage.equals((Object)resource)) {
            return REPLACE;
        }
        if (WONMSG.ConnectMessage.equals((Object)resource)) {
            return CONNECT;
        }
        if (WONMSG.DeactivateMessage.equals((Object)resource)) {
            return DEACTIVATE;
        }
        if (WONMSG.ActivateMessage.equals((Object)resource)) {
            return ACTIVATE;
        }
        if (WONMSG.OpenMessage.equals((Object)resource)) {
            return OPEN;
        }
        if (WONMSG.CloseMessage.equals((Object)resource)) {
            return CLOSE;
        }
        if (WONMSG.DeleteMessage.equals((Object)resource)) {
            return DELETE;
        }
        if (WONMSG.ConnectionMessage.equals((Object)resource)) {
            return CONNECTION_MESSAGE;
        }
        if (WONMSG.AtomMessage.equals((Object)resource)) {
            return ATOM_MESSAGE;
        }
        if (WONMSG.AtomHintMessage.equals((Object)resource)) {
            return ATOM_HINT_MESSAGE;
        }
        if (WONMSG.SocketHintMessage.equals((Object)resource)) {
            return SOCKET_HINT_MESSAGE;
        }
        if (WONMSG.HintFeedbackMessage.equals((Object)resource)) {
            return HINT_FEEDBACK_MESSAGE;
        }
        if (WONMSG.SuccessResponse.equals((Object)resource)) {
            return SUCCESS_RESPONSE;
        }
        if (WONMSG.ChangeNotificationMessage.equals((Object)resource)) {
            return CHANGE_NOTIFICATION;
        }
        if (WONMSG.FailureResponse.equals((Object)resource)) {
            return FAILURE_RESPONSE;
        }
        if (WONMSG.HintNotificationMessage.equals((Object)resource)) {
            return HINT_NOTIFICATION;
        }
        if (WONMSG.AtomCreatedNotificationMessage.equals((Object)resource)) {
            return ATOM_CREATED_NOTIFICATION;
        }
        return null;
    }
}

