/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.message;

import java.net.URI;
import org.apache.jena.rdf.model.Resource;
import won.protocol.vocabulary.WONMSG;

public enum WonMessageDirection {
    FROM_OWNER(WONMSG.FromOwner),
    FROM_SYSTEM(WONMSG.FromSystem),
    FROM_EXTERNAL(WONMSG.FromExternal);

    private Resource resource;

    private WonMessageDirection(Resource resource) {
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public static WonMessageDirection getWonMessageDirection(URI uri) {
        return WonMessageDirection.getWonMessageDirection(WONMSG.toResource(uri));
    }

    public boolean isIdentifiedBy(URI uri) {
        if (uri == null) {
            return false;
        }
        return this.getResource().getURI().toString().equals(uri.toString());
    }

    public static WonMessageDirection getWonMessageDirection(Resource resource) {
        if (WONMSG.FromOwner.equals((Object)resource)) {
            return FROM_OWNER;
        }
        if (WONMSG.FromSystem.equals((Object)resource)) {
            return FROM_SYSTEM;
        }
        if (WONMSG.FromExternal.equals((Object)resource)) {
            return FROM_EXTERNAL;
        }
        return null;
    }
}

