/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.message;

import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.protocol.message.WonMessage;

public class WonMessageDecoder {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static WonMessage decodeFromJsonLd(String message) {
        return WonMessageDecoder.decode(Lang.JSONLD, message);
    }

    public static WonMessage decode(Lang lang, String message) {
        if (message == null || message.equals("")) {
            logger.warn("cannot decode empty or null string to message");
            return null;
        }
        Dataset dataset = DatasetFactory.createGeneral();
        StringReader sr = new StringReader(message);
        RDFDataMgr.read((Dataset)dataset, (StringReader)sr, null, (Lang)lang);
        return WonMessageDecoder.decodeFromDataset(dataset);
    }

    public static WonMessage decodeFromDataset(Dataset message) {
        return new WonMessage(message);
    }
}

