/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.message;

import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import won.protocol.exception.WonMessageBuilderException;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageDirection;
import won.protocol.message.WonMessageType;
import won.protocol.util.CheapInsecureRandomString;
import won.protocol.util.DefaultPrefixUtils;
import won.protocol.util.RdfUtils;
import won.protocol.util.WonRdfUtils;
import won.protocol.vocabulary.RDFG;
import won.protocol.vocabulary.WONMSG;

public class WonMessageBuilder {
    public static final String CONTENT_URI_SUFFIX = "#content-";
    public static final String SIGNATURE_URI_SUFFIX = "#signature-";
    public static final String ENVELOPE_URI_SUFFIX = "#envelope-";
    private static final CheapInsecureRandomString randomString = new CheapInsecureRandomString();
    private static final int RANDOM_SUFFIX_LENGTH = 5;
    private final URI messageURI;
    private URI senderURI;
    private URI senderAtomURI;
    private URI senderNodeURI;
    private URI senderSocketURI;
    private URI recipientURI;
    private URI recipientAtomURI;
    private URI recipientNodeURI;
    private URI recipientSocketURI;
    private URI hintTargetAtomURI;
    private URI hintTargetSocketURI;
    private Double hintScore;
    private Set<URI> injectIntoConnections = new HashSet<URI>();
    private WonMessageType wonMessageType;
    private WonMessageDirection wonMessageDirection;
    private URI isResponseToMessageURI;
    private URI isRemoteResponseToMessageURI;
    private WonMessageType isResponseToMessageType;
    private URI correspondingRemoteMessageURI;
    private URI forwardedMessageURI;
    private Map<URI, Model> contentMap = new HashMap<URI, Model>();
    private Map<URI, Model> signatureMap = new HashMap<URI, Model>();
    private WonMessage wrappedMessage;
    private WonMessage forwardedMessage;
    private Long sentTimestamp;
    private Long receivedTimestamp;

    public WonMessageBuilder(URI messageURI) {
        this.messageURI = messageURI;
    }

    private WonMessageBuilder() {
        throw new UnsupportedOperationException("A messageURI must be provided when creating the WonMessageBuilder");
    }

    public WonMessage build() throws WonMessageBuilderException {
        return this.build(DatasetFactory.createGeneral());
    }

    public WonMessage build(Dataset dataset) throws WonMessageBuilderException {
        if (dataset == null) {
            throw new IllegalArgumentException("specified dataset must not be null. If a new dataset is to be created for the message, build() should be called.");
        }
        if (this.messageURI == null) {
            throw new WonMessageBuilderException("No messageURI specified");
        }
        Model envelopeGraph = ModelFactory.createDefaultModel();
        DefaultPrefixUtils.setDefaultPrefixes(envelopeGraph);
        String envelopeGraphURI = RdfUtils.createNewGraphURI(this.messageURI.toString(), ENVELOPE_URI_SUFFIX, 4, graphUri -> {
            if (dataset.containsNamedModel(graphUri)) {
                return false;
            }
            if (this.wrappedMessage == null) {
                return true;
            }
            if (this.wrappedMessage.getEnvelopeGraphURIs().contains(graphUri)) {
                return false;
            }
            return !this.wrappedMessage.getContentGraphURIs().contains(graphUri);
        }).toString();
        dataset.addNamedModel(envelopeGraphURI, envelopeGraph);
        Resource messageEventResource = envelopeGraph.createResource(this.messageURI.toString(), this.wonMessageDirection.getResource());
        Resource envelopeGraphResource = envelopeGraph.createResource(envelopeGraphURI, WONMSG.EnvelopeGraph);
        envelopeGraphResource.addProperty(RDFG.SUBGRAPH_OF, (RDFNode)messageEventResource);
        this.addWrappedOrForwardedMessage(dataset, envelopeGraph, envelopeGraphResource, this.messageURI);
        if (this.wonMessageDirection == null) {
            throw new IllegalStateException("envelopeType must be set!");
        }
        if (this.wonMessageType != null) {
            messageEventResource.addProperty(WONMSG.messageType, (RDFNode)this.wonMessageType.getResource());
        }
        messageEventResource.addLiteral(WONMSG.PROTOCOL_VERSION, envelopeGraph.createTypedLiteral("1.0"));
        if (this.senderURI != null) {
            messageEventResource.addProperty(WONMSG.sender, (RDFNode)envelopeGraph.createResource(this.senderURI.toString()));
        }
        if (this.senderAtomURI != null) {
            messageEventResource.addProperty(WONMSG.senderAtom, (RDFNode)envelopeGraph.createResource(this.senderAtomURI.toString()));
        }
        if (this.senderNodeURI != null) {
            messageEventResource.addProperty(WONMSG.senderNode, (RDFNode)envelopeGraph.createResource(this.senderNodeURI.toString()));
        }
        if (this.senderSocketURI != null) {
            messageEventResource.addProperty(WONMSG.senderSocket, (RDFNode)envelopeGraph.createResource(this.senderSocketURI.toString()));
        }
        if (this.recipientURI != null) {
            messageEventResource.addProperty(WONMSG.recipient, (RDFNode)envelopeGraph.createResource(this.recipientURI.toString()));
        }
        if (this.recipientAtomURI != null) {
            messageEventResource.addProperty(WONMSG.recipientAtom, (RDFNode)envelopeGraph.createResource(this.recipientAtomURI.toString()));
        }
        if (this.recipientNodeURI != null) {
            messageEventResource.addProperty(WONMSG.recipientNode, (RDFNode)envelopeGraph.createResource(this.recipientNodeURI.toString()));
        }
        if (this.recipientSocketURI != null) {
            messageEventResource.addProperty(WONMSG.recipientSocket, (RDFNode)envelopeGraph.createResource(this.recipientSocketURI.toString()));
        }
        if (this.wonMessageType == WonMessageType.ATOM_HINT_MESSAGE) {
            if (this.hintTargetAtomURI == null) {
                throw new IllegalArgumentException("AtomHintMessage must have a hintTargetAtom");
            }
            if (this.hintScore == null) {
                throw new IllegalArgumentException("AtomHintMessage must have a hintScore");
            }
            if (this.hintTargetSocketURI != null) {
                throw new IllegalArgumentException("AtomHintMessage must not have a hintTargetSocket");
            }
            if (this.recipientSocketURI != null) {
                throw new IllegalArgumentException("AtomHintMessage must not have a recipientSocket");
            }
            messageEventResource.addProperty(WONMSG.hintTargetAtom, (RDFNode)envelopeGraph.createResource(this.hintTargetAtomURI.toString()));
            messageEventResource.addProperty(WONMSG.hintScore, this.hintScore.toString(), (RDFDatatype)XSDDatatype.XSDfloat);
        } else if (this.wonMessageType == WonMessageType.SOCKET_HINT_MESSAGE) {
            if (this.hintTargetSocketURI == null) {
                throw new IllegalArgumentException("SocketHintMessage must have a hintTargetSocket");
            }
            if (this.hintScore == null) {
                throw new IllegalArgumentException("SocketHintMessage must have a hintScore");
            }
            if (this.hintTargetAtomURI != null) {
                throw new IllegalArgumentException("SocketHintMessage must not have a hintTargetAtom");
            }
            if (this.recipientSocketURI == null) {
                throw new IllegalArgumentException("SocketHintMessage must have a recipientSocket");
            }
            messageEventResource.addProperty(WONMSG.hintTargetSocket, (RDFNode)envelopeGraph.createResource(this.hintTargetSocketURI.toString()));
            messageEventResource.addProperty(WONMSG.hintScore, this.hintScore.toString(), (RDFDatatype)XSDDatatype.XSDfloat);
        }
        if (!this.injectIntoConnections.isEmpty()) {
            this.injectIntoConnections.forEach(receiver -> messageEventResource.addProperty(WONMSG.injectIntoConnection, (RDFNode)envelopeGraph.getResource(receiver.toString())));
        }
        if (this.isResponseToMessageURI != null) {
            if (this.wonMessageType != WonMessageType.SUCCESS_RESPONSE && this.wonMessageType != WonMessageType.FAILURE_RESPONSE) {
                throw new IllegalArgumentException("isResponseToMessageURI can only be used for SUCCESS_RESPONSE and FAILURE_RESPONSE types");
            }
            if (this.isResponseToMessageType == null) {
                throw new IllegalArgumentException("response messages must specify the type of message they are a response to. Use setIsResponseToMessageType(type)");
            }
            messageEventResource.addProperty(WONMSG.isResponseTo, (RDFNode)envelopeGraph.createResource(this.isResponseToMessageURI.toString()));
            messageEventResource.addProperty(WONMSG.isResponseToMessageType, (RDFNode)this.isResponseToMessageType.getResource());
            if (this.isRemoteResponseToMessageURI != null) {
                messageEventResource.addProperty(WONMSG.isRemoteResponseTo, (RDFNode)envelopeGraph.createResource(this.isRemoteResponseToMessageURI.toString()));
            }
        }
        if (this.correspondingRemoteMessageURI != null) {
            messageEventResource.addProperty(WONMSG.correspondingRemoteMessage, (RDFNode)envelopeGraph.createResource(this.correspondingRemoteMessageURI.toString()));
        }
        if (this.forwardedMessageURI != null) {
            messageEventResource.addProperty(WONMSG.forwardedMessage, (RDFNode)envelopeGraph.createResource(this.forwardedMessageURI.toString()));
        }
        if (this.sentTimestamp != null) {
            messageEventResource.addProperty(WONMSG.sentTimestamp, (RDFNode)envelopeGraph.createTypedLiteral((Object)this.sentTimestamp));
        }
        if (this.receivedTimestamp != null) {
            messageEventResource.addProperty(WONMSG.receivedTimestamp, (RDFNode)envelopeGraph.createTypedLiteral((Object)this.receivedTimestamp));
        }
        for (URI contentURI : this.contentMap.keySet()) {
            String contentUriString = contentURI.toString();
            dataset.addNamedModel(contentUriString, this.contentMap.get(contentURI));
            messageEventResource.addProperty(WONMSG.content, (RDFNode)messageEventResource.getModel().createResource(contentUriString));
            envelopeGraph.createStatement(envelopeGraph.getResource(contentURI.toString()), RDFG.SUBGRAPH_OF, (RDFNode)messageEventResource);
            Model signatureGraph = this.signatureMap.get(contentURI);
            if (signatureGraph == null) continue;
            throw new UnsupportedOperationException("signatures are not supported yet");
        }
        return new WonMessage(dataset);
    }

    public void addWrappedOrForwardedMessage(Dataset dataset, Model envelopeGraph, Resource envelopeGraphResource, URI messageURI) {
        if (this.wrappedMessage != null) {
            if (this.forwardedMessage != null) {
                throw new IllegalStateException("cannot wrap and forward with the same builder");
            }
            this.addAsContainedEnvelope(dataset, envelopeGraph, envelopeGraphResource, this.wrappedMessage, messageURI);
        }
        if (this.forwardedMessage != null) {
            if (this.wrappedMessage != null) {
                throw new IllegalStateException("cannot wrap and forward with the same builder");
            }
            this.addAsContainedEnvelope(dataset, envelopeGraph, envelopeGraphResource, this.forwardedMessage, messageURI);
        }
    }

    public void addAsContainedEnvelope(Dataset dataset, Model envelopeGraph, Resource envelopeGraphResource, WonMessage messageToAdd, URI messageURI) {
        String messageUriString = messageURI.toString();
        envelopeGraphResource.addProperty(WONMSG.containsEnvelope, (RDFNode)envelopeGraph.getResource(messageToAdd.getOuterEnvelopeGraphURI().toString()));
        Iterator names = messageToAdd.getCompleteDataset().listNames();
        while (names.hasNext()) {
            String graphUri = (String)names.next();
            Model modelToAdd = messageToAdd.getCompleteDataset().getNamedModel(graphUri);
            dataset.addNamedModel(graphUri, modelToAdd);
            if (modelToAdd.contains(modelToAdd.getResource(graphUri), RDFG.SUBGRAPH_OF, (RDFNode)modelToAdd.getResource(messageUriString))) continue;
            envelopeGraph.createStatement(envelopeGraph.getResource(graphUri), RDFG.SUBGRAPH_OF, (RDFNode)envelopeGraph.getResource(messageUriString));
        }
    }

    public static WonMessageBuilder wrap(WonMessage toWrap) {
        WonMessageBuilder builder = new WonMessageBuilder(toWrap.getMessageURI()).setWonMessageDirection(toWrap.getEnvelopeType());
        builder.wrappedMessage = WonRdfUtils.MessageUtils.copyByDatasetSerialization(toWrap);
        return builder;
    }

    public static WonMessageBuilder setMessagePropertiesForOpen(URI messageURI, URI localConnection, URI localAtom, URI localWonNode, URI targetConnection, URI targetAtom, URI remoteWonNode, Optional<URI> targetSocket, String welcomeMessage) {
        WonMessageBuilder builder = new WonMessageBuilder(messageURI).setWonMessageDirection(WonMessageDirection.FROM_OWNER).setWonMessageType(WonMessageType.OPEN).setSenderURI(localConnection).setSenderAtomURI(localAtom).setSenderNodeURI(localWonNode).setRecipientURI(targetConnection).setRecipientAtomURI(targetAtom).setRecipientNodeURI(remoteWonNode);
        if (targetSocket.isPresent()) {
            builder.setRecipientSocketURI(targetSocket.get());
        }
        return builder.setTextMessage(welcomeMessage).setSentTimestampToNow();
    }

    public static WonMessageBuilder setMessagePropertiesForOpen(URI messageURI, URI localConnection, URI localAtom, URI localWonNode, URI targetConnection, URI targetAtom, URI remoteWonNode, String welcomeMessage) {
        return WonMessageBuilder.setMessagePropertiesForOpen(messageURI, localConnection, localAtom, localWonNode, targetConnection, targetAtom, remoteWonNode, Optional.empty(), welcomeMessage);
    }

    public static WonMessageBuilder setMessagePropertiesForOpen(URI messageURI, WonMessage connectToReactTo, String welcomeMessage) {
        return WonMessageBuilder.setMessagePropertiesForOpen(messageURI, connectToReactTo.getRecipientURI(), connectToReactTo.getRecipientAtomURI(), connectToReactTo.getRecipientNodeURI(), connectToReactTo.getSenderURI(), connectToReactTo.getSenderAtomURI(), connectToReactTo.getSenderNodeURI(), Optional.of(connectToReactTo.getSenderSocketURI()), welcomeMessage);
    }

    public static WonMessageBuilder setMessagePropertiesForClose(URI messageURI, WonMessage connectToReactTo, String farewellMessage) {
        return WonMessageBuilder.setMessagePropertiesForClose(messageURI, connectToReactTo.getRecipientURI(), connectToReactTo.getRecipientAtomURI(), connectToReactTo.getRecipientNodeURI(), connectToReactTo.getSenderURI(), connectToReactTo.getSenderAtomURI(), connectToReactTo.getSenderNodeURI(), farewellMessage);
    }

    public static WonMessageBuilder setMessagePropertiesForClose(URI messageURI, URI localConnection, URI localAtom, URI localWonNode, URI targetConnection, URI targetAtom, URI remoteWonNode, String farewellMessage) {
        return WonMessageBuilder.setMessagePropertiesForClose(messageURI, WonMessageDirection.FROM_OWNER, localConnection, localAtom, localWonNode, targetConnection, targetAtom, remoteWonNode, farewellMessage);
    }

    public static WonMessageBuilder setMessagePropertiesForClose(URI messageURI, WonMessageDirection direction, URI localConnection, URI localAtom, URI localWonNode, URI targetConnection, URI targetAtom, URI remoteWonNode, String farewellMessage) {
        return new WonMessageBuilder(messageURI).setWonMessageDirection(direction).setWonMessageType(WonMessageType.CLOSE).setSenderURI(localConnection).setSenderAtomURI(localAtom).setSenderNodeURI(localWonNode).setRecipientURI(targetConnection).setRecipientAtomURI(targetAtom).setRecipientNodeURI(remoteWonNode).setTextMessage(farewellMessage).setSentTimestampToNow();
    }

    public static WonMessageBuilder setMessagePropertiesForClose(URI messageURI, URI localConnection, URI localAtom, URI localWonNode, String farewellMessage) {
        return WonMessageBuilder.setMessagePropertiesForClose(messageURI, WonMessageDirection.FROM_OWNER, localConnection, localAtom, localWonNode, farewellMessage);
    }

    public static WonMessageBuilder setMessagePropertiesForClose(URI messageURI, WonMessageDirection direction, URI localConnection, URI localAtom, URI localWonNode, String farewellMessage) {
        return WonMessageBuilder.setMessagePropertiesForClose(messageURI, WonMessageDirection.FROM_OWNER, localConnection, localAtom, localWonNode, localConnection, localAtom, localWonNode, farewellMessage);
    }

    public static WonMessageBuilder setMessagePropertiesForLocalOnlyClose(URI messageURI, URI localConnection, URI localAtom, URI localWonNode) {
        return new WonMessageBuilder(messageURI).setWonMessageDirection(WonMessageDirection.FROM_SYSTEM).setWonMessageType(WonMessageType.CLOSE).setSenderURI(localConnection).setSenderAtomURI(localAtom).setSenderNodeURI(localWonNode).setSentTimestampToNow();
    }

    public static WonMessageBuilder setMessagePropertiesForSystemMessageToTargetAtom(URI messageURI, URI localConnection, URI localAtom, URI localWonNode, URI targetConnection, URI targetAtom, URI remoteNode, String textMessage) {
        return new WonMessageBuilder(messageURI).setWonMessageDirection(WonMessageDirection.FROM_SYSTEM).setWonMessageType(WonMessageType.CONNECTION_MESSAGE).setSenderURI(localConnection).setSenderAtomURI(localAtom).setSenderNodeURI(localWonNode).setRecipientURI(targetConnection).setRecipientAtomURI(targetAtom).setRecipientNodeURI(remoteNode).setTextMessage(textMessage).setSentTimestampToNow();
    }

    public static WonMessageBuilder setMessagePropertiesForSystemChangeNotificationMessageToTargetAtom(URI messageURI, URI localConnection, URI localAtom, URI localWonNode, URI targetConnection, URI targetAtom, URI remoteNode, String textMessage) {
        return new WonMessageBuilder(messageURI).setWonMessageDirection(WonMessageDirection.FROM_SYSTEM).setWonMessageType(WonMessageType.CHANGE_NOTIFICATION).setSenderURI(localConnection).setSenderAtomURI(localAtom).setSenderNodeURI(localWonNode).setRecipientURI(targetConnection).setRecipientAtomURI(targetAtom).setRecipientNodeURI(remoteNode).setTextMessage(textMessage).setSentTimestampToNow();
    }

    public static WonMessageBuilder setMessagePropertiesForSystemChangeNotificationMessageToTargetAtom(URI messageURI, URI localConnection, URI localAtom, URI localWonNode, URI targetConnection, URI targetAtom, URI remoteNode) {
        return WonMessageBuilder.setMessagePropertiesForSystemChangeNotificationMessageToTargetAtom(messageURI, localConnection, localAtom, localWonNode, targetConnection, targetAtom, remoteNode, null);
    }

    public static WonMessageBuilder setMessagePropertiesForDeactivateFromOwner(URI messageURI, URI localAtom, URI localWonNode) {
        return new WonMessageBuilder(messageURI).setWonMessageDirection(WonMessageDirection.FROM_OWNER).setWonMessageType(WonMessageType.DEACTIVATE).setSenderAtomURI(localAtom).setSenderNodeURI(localWonNode).setRecipientAtomURI(localAtom).setRecipientNodeURI(localWonNode).setSentTimestampToNow();
    }

    public static WonMessageBuilder setMessagePropertiesForDeleteFromOwner(URI messageURI, URI localAtom, URI localWonNode) {
        return new WonMessageBuilder(messageURI).setWonMessageDirection(WonMessageDirection.FROM_OWNER).setWonMessageType(WonMessageType.DELETE).setSenderAtomURI(localAtom).setSenderNodeURI(localWonNode).setRecipientAtomURI(localAtom).setRecipientNodeURI(localWonNode).setSentTimestampToNow();
    }

    public static WonMessageBuilder setMessagePropertiesForDeactivateFromSystem(URI messageURI, URI localAtom, URI localWonNode) {
        return new WonMessageBuilder(messageURI).setWonMessageDirection(WonMessageDirection.FROM_SYSTEM).setWonMessageType(WonMessageType.DEACTIVATE).setSenderAtomURI(localAtom).setSenderNodeURI(localWonNode).setRecipientAtomURI(localAtom).setRecipientNodeURI(localWonNode).setSentTimestampToNow();
    }

    public static WonMessageBuilder setMessagePropertiesForAtomMessageFromSystem(URI messageURI, URI localAtom, URI localWonNode) {
        return new WonMessageBuilder(messageURI).setWonMessageDirection(WonMessageDirection.FROM_SYSTEM).setWonMessageType(WonMessageType.ATOM_MESSAGE).setSenderAtomURI(localAtom).setSenderNodeURI(localWonNode).setRecipientAtomURI(localAtom).setRecipientNodeURI(localWonNode).setSentTimestampToNow();
    }

    public static WonMessageBuilder setMessagePropertiesForConnect(URI messageURI, Optional<URI> localSocket, URI localAtom, URI localWonNode, Optional<URI> targetSocket, URI targetAtom, URI remoteWonNode, String welcomeMessage) {
        Model model = ModelFactory.createDefaultModel();
        RdfUtils.findOrCreateBaseResource(model);
        RdfUtils.replaceBaseResource(model, model.createResource(messageURI.toString()));
        if (welcomeMessage != null) {
            WonRdfUtils.MessageUtils.addMessage(model, welcomeMessage);
        }
        WonMessageBuilder builder = new WonMessageBuilder(messageURI).setWonMessageDirection(WonMessageDirection.FROM_OWNER).setWonMessageType(WonMessageType.CONNECT).setSenderAtomURI(localAtom).setSenderNodeURI(localWonNode).setRecipientAtomURI(targetAtom).setRecipientNodeURI(remoteWonNode);
        if (localSocket.isPresent()) {
            builder.setSenderSocketURI(localSocket.get());
        }
        if (targetSocket.isPresent()) {
            builder.setRecipientSocketURI(targetSocket.get());
        }
        return builder.addContent(model).setSentTimestampToNow();
    }

    public static WonMessageBuilder setMessagePropertiesForCreate(URI messageURI, URI atomURI, URI wonNodeURI) {
        return new WonMessageBuilder(messageURI).setWonMessageDirection(WonMessageDirection.FROM_OWNER).setWonMessageType(WonMessageType.CREATE_ATOM).setSenderAtomURI(atomURI).setSenderNodeURI(wonNodeURI).setRecipientNodeURI(wonNodeURI).setSentTimestampToNow();
    }

    public static WonMessageBuilder setMessagePropertiesForReplace(URI messageURI, URI atomURI, URI wonNodeURI) {
        return new WonMessageBuilder(messageURI).setWonMessageDirection(WonMessageDirection.FROM_OWNER).setWonMessageType(WonMessageType.REPLACE).setSenderAtomURI(atomURI).setSenderNodeURI(wonNodeURI).setRecipientAtomURI(atomURI).setRecipientNodeURI(wonNodeURI).setSentTimestampToNow();
    }

    public static WonMessageBuilder setMessagePropertiesForHintToAtom(URI messageURI, URI atomURI, URI wonNodeURI, URI otherAtomURI, URI matcherURI, double score) {
        WonMessageBuilder builder = new WonMessageBuilder(messageURI).setWonMessageDirection(WonMessageDirection.FROM_EXTERNAL).setWonMessageType(WonMessageType.ATOM_HINT_MESSAGE).setSenderNodeURI(matcherURI).setRecipientAtomURI(atomURI).setRecipientNodeURI(wonNodeURI).setHintTargetAtomURI(otherAtomURI).setHintScore(score);
        return builder.setSentTimestampToNow();
    }

    public static WonMessageBuilder setMessagePropertiesForHintToSocket(URI messageURI, URI recipientAtomURI, URI recipientSocketURI, URI wonNodeURI, URI targetSocketURI, URI matcherURI, double score) {
        WonMessageBuilder builder = new WonMessageBuilder(messageURI).setWonMessageDirection(WonMessageDirection.FROM_EXTERNAL).setWonMessageType(WonMessageType.SOCKET_HINT_MESSAGE).setSenderNodeURI(matcherURI).setRecipientAtomURI(recipientAtomURI).setRecipientSocketURI(recipientSocketURI).setRecipientNodeURI(wonNodeURI).setHintTargetSocketURI(targetSocketURI).setHintScore(score);
        return builder.setSentTimestampToNow();
    }

    public static WonMessageBuilder setMessagePropertiesForHintFeedback(URI messageURI, URI connectionURI, URI atomURI, URI wonNodeURI, boolean booleanFeedbackValue) {
        Model contentModel = WonRdfUtils.MessageUtils.binaryFeedbackMessage(connectionURI, booleanFeedbackValue);
        Resource msgResource = contentModel.createResource(messageURI.toString());
        RdfUtils.replaceBaseResource(contentModel, msgResource);
        return new WonMessageBuilder(messageURI).setWonMessageDirection(WonMessageDirection.FROM_OWNER).setWonMessageType(WonMessageType.HINT_FEEDBACK_MESSAGE).setRecipientNodeURI(wonNodeURI).setRecipientURI(connectionURI).setRecipientAtomURI(atomURI).setSenderNodeURI(wonNodeURI).setSenderAtomURI(atomURI).setSenderURI(connectionURI).setSentTimestampToNow().addContent(contentModel);
    }

    public static WonMessageBuilder setMessagePropertiesForConnectionMessage(URI messageURI, URI localConnection, URI localAtom, URI localWonNode, URI targetConnection, URI targetAtom, URI remoteWonNode, Model content) {
        return new WonMessageBuilder(messageURI).setWonMessageDirection(WonMessageDirection.FROM_OWNER).setWonMessageType(WonMessageType.CONNECTION_MESSAGE).setSenderURI(localConnection).setSenderAtomURI(localAtom).setSenderNodeURI(localWonNode).setRecipientURI(targetConnection).setRecipientAtomURI(targetAtom).setRecipientNodeURI(remoteWonNode).addContent(content).setSentTimestampToNow();
    }

    public static WonMessageBuilder setMessagePropertiesForConnectionMessage(URI messageURI, URI localConnection, URI localAtom, URI localWonNode, URI targetConnection, URI targetAtom, URI remoteWonNode, String textMessage) {
        return new WonMessageBuilder(messageURI).setWonMessageDirection(WonMessageDirection.FROM_OWNER).setWonMessageType(WonMessageType.CONNECTION_MESSAGE).setSenderURI(localConnection).setSenderAtomURI(localAtom).setSenderNodeURI(localWonNode).setRecipientURI(targetConnection).setRecipientAtomURI(targetAtom).setRecipientNodeURI(remoteWonNode).setTextMessage(textMessage).setSentTimestampToNow();
    }

    public static WonMessageBuilder setMessagePropertiesForAtomCreatedNotification(URI messageURI, URI localAtom, URI localWonNode) {
        return new WonMessageBuilder(messageURI).setWonMessageType(WonMessageType.ATOM_CREATED_NOTIFICATION).setWonMessageDirection(WonMessageDirection.FROM_EXTERNAL).setSenderAtomURI(localAtom).setSenderNodeURI(localWonNode).setSentTimestampToNow();
    }

    public static WonMessageBuilder setPropertiesForPassingMessageToRemoteNode(WonMessage ownerOrSystemMsg, URI newMessageUri) {
        return WonMessageBuilder.setPropertiesForPassingMessageToRemoteNodeAndCopyLocalMessage(ownerOrSystemMsg, newMessageUri);
    }

    private WonMessageBuilder forward(WonMessage toForward) {
        this.forwardedMessage = WonRdfUtils.MessageUtils.copyByDatasetSerialization(toForward);
        return this;
    }

    private static WonMessageBuilder setPropertiesForPassingMessageToRemoteNodeAndCopyLocalMessage(WonMessage ownerOrSystemMsg, URI newMessageUri) {
        return new WonMessageBuilder(newMessageUri).setSentTimestamp(new Date().getTime()).forward(ownerOrSystemMsg).setCorrespondingRemoteMessageURI(ownerOrSystemMsg.getMessageURI()).setWonMessageDirection(WonMessageDirection.FROM_EXTERNAL);
    }

    @Deprecated
    public static WonMessageBuilder setPropertiesForPassingMessageToOwner(WonMessage externalMsg) {
        return WonMessageBuilder.wrap(externalMsg).setReceivedTimestamp(new Date().getTime());
    }

    public static WonMessageBuilder setPropertiesForNodeResponse(WonMessage originalMessage, boolean isSuccess, URI messageURI) {
        WonMessageBuilder messageBuilder = new WonMessageBuilder(messageURI).setWonMessageType(isSuccess ? WonMessageType.SUCCESS_RESPONSE : WonMessageType.FAILURE_RESPONSE);
        WonMessageDirection origDirection = originalMessage.getEnvelopeType();
        if (WonMessageDirection.FROM_EXTERNAL == origDirection) {
            messageBuilder.setSenderNodeURI(originalMessage.getRecipientNodeURI()).setSenderAtomURI(originalMessage.getRecipientAtomURI()).setSenderURI(originalMessage.getRecipientURI()).setIsRemoteResponseToMessageURI(originalMessage.getCorrespondingRemoteMessageURI());
        } else if (WonMessageDirection.FROM_OWNER == origDirection || WonMessageDirection.FROM_SYSTEM == origDirection) {
            messageBuilder.setSenderNodeURI(originalMessage.getSenderNodeURI()).setSenderAtomURI(originalMessage.getSenderAtomURI()).setSenderURI(originalMessage.getSenderURI());
        }
        messageBuilder.setRecipientAtomURI(originalMessage.getSenderAtomURI()).setRecipientNodeURI(originalMessage.getSenderNodeURI()).setRecipientURI(originalMessage.getSenderURI()).setIsResponseToMessageURI(originalMessage.getMessageURI()).setIsResponseToMessageType(originalMessage.getMessageType()).setWonMessageDirection(WonMessageDirection.FROM_SYSTEM);
        return messageBuilder;
    }

    public WonMessageBuilder setSenderURI(URI senderURI) {
        this.senderURI = senderURI;
        return this;
    }

    public WonMessageBuilder setSenderAtomURI(URI senderAtomURI) {
        this.senderAtomURI = senderAtomURI;
        return this;
    }

    public WonMessageBuilder setSenderNodeURI(URI senderNodeURI) {
        this.senderNodeURI = senderNodeURI;
        return this;
    }

    public WonMessageBuilder setSenderSocketURI(URI senderSocketURI) {
        this.senderSocketURI = senderSocketURI;
        return this;
    }

    public WonMessageBuilder setRecipientURI(URI recipientURI) {
        this.recipientURI = recipientURI;
        return this;
    }

    public WonMessageBuilder setRecipientAtomURI(URI recipientAtomURI) {
        this.recipientAtomURI = recipientAtomURI;
        return this;
    }

    public WonMessageBuilder setRecipientNodeURI(URI recipientNodeURI) {
        this.recipientNodeURI = recipientNodeURI;
        return this;
    }

    public WonMessageBuilder setRecipientSocketURI(URI recipientSocketURI) {
        this.recipientSocketURI = recipientSocketURI;
        return this;
    }

    public WonMessageBuilder setWonMessageType(WonMessageType wonMessageType) {
        this.wonMessageType = wonMessageType;
        return this;
    }

    public WonMessageBuilder setWonMessageDirection(WonMessageDirection wonMessageDirection) {
        this.wonMessageDirection = wonMessageDirection;
        return this;
    }

    public WonMessageBuilder addContent(Model content) {
        this.addContentInternal(content);
        return this;
    }

    private URI addContentInternal(Model content) {
        URI contentGraphUri = RdfUtils.createNewGraphURI(this.messageURI.toString(), CONTENT_URI_SUFFIX, 4, new RdfUtils.GraphNameCheck(){

            @Override
            public boolean isGraphUriOk(String graphUri) {
                return !WonMessageBuilder.this.contentMap.keySet().contains(URI.create(graphUri));
            }
        });
        this.contentMap.put(contentGraphUri, content);
        return contentGraphUri;
    }

    public WonMessageBuilder addContent(Dataset dataset) {
        Dataset toAdd = RdfUtils.cloneDataset(dataset);
        Model model = toAdd.getDefaultModel();
        if (model != null && model.size() > 0L) {
            this.addContent(model);
        }
        final HashMap changedGraphUris = new HashMap();
        RdfUtils.toNamedModelStream(toAdd, false).forEach(namedModel -> {
            if (namedModel.getModel().size() == 0L) {
                return;
            }
            URI newUri = this.addContentInternal(namedModel.getModel());
            changedGraphUris.put(namedModel.getName(), newUri.toString());
        });
        RdfUtils.visit(toAdd, new RdfUtils.ModelVisitor<Object>(){

            @Override
            public Object visit(Model model) {
                if (model.size() == 0L) {
                    return null;
                }
                changedGraphUris.entrySet().stream().forEach(graphNameMapping -> {
                    Resource refToOld = model.getResource((String)graphNameMapping.getKey());
                    Resource refToNew = model.getResource((String)graphNameMapping.getValue());
                    RdfUtils.replaceResourceInModel(refToOld, refToNew);
                });
                return null;
            }
        });
        return this;
    }

    public Model getUnsignedContentGraph() {
        if (this.contentMap.isEmpty()) {
            Model contentGraph = ModelFactory.createDefaultModel();
            RdfUtils.replaceBaseURI(contentGraph, this.messageURI.toString());
            this.addContent(contentGraph);
            return contentGraph;
        }
        for (Map.Entry<URI, Model> entry : this.contentMap.entrySet()) {
            if (this.signatureMap.containsKey(entry.getKey())) continue;
            return entry.getValue();
        }
        Model contentGraph = ModelFactory.createDefaultModel();
        RdfUtils.replaceBaseURI(contentGraph, this.messageURI.toString());
        this.addContent(contentGraph);
        return contentGraph;
    }

    public WonMessageBuilder setIsResponseToMessageURI(URI isResponseToMessageURI) {
        this.isResponseToMessageURI = isResponseToMessageURI;
        return this;
    }

    public WonMessageBuilder setIsRemoteResponseToMessageURI(URI isRemoteResponseToMessageURI) {
        this.isRemoteResponseToMessageURI = isRemoteResponseToMessageURI;
        return this;
    }

    public WonMessageBuilder setIsResponseToMessageType(WonMessageType isResponseToMessageType) {
        this.isResponseToMessageType = isResponseToMessageType;
        return this;
    }

    public WonMessageBuilder setCorrespondingRemoteMessageURI(URI correspondingRemoteMessageURI) {
        this.correspondingRemoteMessageURI = correspondingRemoteMessageURI;
        return this;
    }

    public WonMessageBuilder setForwardedMessageURI(URI forwardedMessageURI) {
        this.forwardedMessageURI = forwardedMessageURI;
        return this;
    }

    public WonMessageBuilder setInjectIntoConnections(Collection<URI> forwardToRecipientUris) {
        this.injectIntoConnections.addAll(forwardToRecipientUris);
        return this;
    }

    public WonMessageBuilder setSentTimestamp(long sentTimestamp) {
        this.sentTimestamp = sentTimestamp;
        return this;
    }

    public WonMessageBuilder setReceivedTimestamp(Long receivedTimestamp) {
        this.receivedTimestamp = receivedTimestamp;
        return this;
    }

    public WonMessageBuilder setSentTimestampToNow() {
        this.sentTimestamp = System.currentTimeMillis();
        return this;
    }

    public WonMessageBuilder setReceivedTimestampToNow() {
        this.receivedTimestamp = System.currentTimeMillis();
        return this;
    }

    public WonMessageBuilder setHintScore(Double hintScore) {
        this.hintScore = hintScore;
        return this;
    }

    public WonMessageBuilder setHintTargetAtomURI(URI hintTargetAtomURI) {
        this.hintTargetAtomURI = hintTargetAtomURI;
        return this;
    }

    public WonMessageBuilder setHintTargetSocketURI(URI hintTargetSocketURI) {
        this.hintTargetSocketURI = hintTargetSocketURI;
        return this;
    }

    public WonMessageBuilder setTextMessage(String textMessage) {
        if (textMessage != null) {
            WonRdfUtils.MessageUtils.addMessage(this.getUnsignedContentGraph(), textMessage);
        }
        return this;
    }

    public static WonMessageBuilder copyEnvelopeFromWonMessage(WonMessage wonMessage) {
        WonMessageBuilder builder = new WonMessageBuilder(wonMessage.getMessageURI()).setWonMessageType(wonMessage.getMessageType()).setRecipientURI(wonMessage.getRecipientURI()).setRecipientAtomURI(wonMessage.getRecipientAtomURI()).setRecipientNodeURI(wonMessage.getRecipientNodeURI()).setSenderURI(wonMessage.getSenderURI()).setSenderAtomURI(wonMessage.getSenderAtomURI()).setSenderNodeURI(wonMessage.getSenderNodeURI());
        if (wonMessage.getIsResponseToMessageType() != null) {
            builder.setIsResponseToMessageType(wonMessage.getIsResponseToMessageType());
        }
        if (wonMessage.getIsResponseToMessageURI() != null) {
            builder.setIsResponseToMessageURI(wonMessage.getIsResponseToMessageURI());
        }
        if (wonMessage.getIsRemoteResponseToMessageURI() != null) {
            builder.setIsRemoteResponseToMessageURI(wonMessage.getIsRemoteResponseToMessageURI());
        }
        return builder;
    }

    public static WonMessage forwardReceivedNodeToNodeMessageAsNodeToNodeMessage(URI newMessageUri, WonMessage wonMessage, URI connectionURI, URI atomURI, URI wonNodeUri, URI targetConnectionURI, URI targetAtomURI, URI remoteWonNodeUri) {
        WonMessageBuilder builder = new WonMessageBuilder(newMessageUri).setWonMessageType(wonMessage.getMessageType()).forward(wonMessage).setForwardedMessageURI(wonMessage.getMessageURI()).setSenderAtomURI(atomURI).setSenderURI(connectionURI).setSenderNodeURI(wonNodeUri).setSentTimestamp(System.currentTimeMillis()).setRecipientURI(targetConnectionURI).setRecipientAtomURI(targetAtomURI).setRecipientNodeURI(remoteWonNodeUri).setIsRemoteResponseToMessageURI(wonMessage.getIsRemoteResponseToMessageURI()).setIsResponseToMessageURI(wonMessage.getIsResponseToMessageURI()).setIsResponseToMessageType(wonMessage.getIsResponseToMessageType()).setWonMessageDirection(WonMessageDirection.FROM_SYSTEM);
        return builder.build();
    }
}

