/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.message;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.tdb.TDB;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.protocol.message.WonMessageDirection;
import won.protocol.message.WonMessageType;
import won.protocol.util.RdfUtils;
import won.protocol.vocabulary.RDFG;
import won.protocol.vocabulary.SFSIG;
import won.protocol.vocabulary.WONMSG;

public class WonMessage
implements Serializable {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Dataset messageContent;
    private Dataset completeDataset;
    private List<Model> envelopeGraphs;
    private List<String> envelopeGraphNames;
    private URI outerEnvelopeGraphURI;
    private Model outerEnvelopeGraph;
    private URI messageURI;
    private WonMessageType messageType;
    private WonMessageDirection envelopeType;
    private URI senderURI;
    private URI senderAtomURI;
    private URI senderNodeURI;
    private URI senderSocketURI;
    private URI recipientURI;
    private URI recipientAtomURI;
    private URI recipientNodeURI;
    private URI recipientSocketURI;
    private URI hintTargetAtomURI;
    private URI hintTargetSocketURI;
    private Double hintScore;
    private List<URI> previousMessages = null;
    private List<URI> injectIntoConnections = null;
    private URI isResponseToMessageURI;
    private URI isRemoteResponseToMessageURI;
    private List<String> contentGraphNames;
    private WonMessageType isResponseToMessageType;
    private URI correspondingRemoteMessageURI;
    private URI forwardedMessageURI;
    private URI innermostMessageURI;
    private List<AttachmentHolder> attachmentHolders;
    private Map<String, Resource> graphSignatures;

    public WonMessage(Dataset completeDataset) {
        this.completeDataset = completeDataset;
    }

    public static WonMessage deepCopy(WonMessage original) {
        return new WonMessage(RdfUtils.cloneDataset(original.completeDataset));
    }

    public synchronized Dataset getCompleteDataset() {
        return RdfUtils.cloneDataset(this.completeDataset);
    }

    public synchronized void addMessageProperty(Property property, RDFNode value) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("adding property {}, value {}, to message {} in envelope {}", new Object[]{property, value, this.getMessageURI(), this.getOuterEnvelopeGraphURI()});
        }
        this.getOuterEnvelopeGraph().getResource(this.getMessageURI().toString()).addProperty(property, value);
    }

    public synchronized void addMessageProperty(Property property, String uri) {
        Resource valueAsRdfNode = this.getOuterEnvelopeGraph().createResource(uri);
        this.addMessageProperty(property, (RDFNode)valueAsRdfNode);
    }

    public synchronized void addMessageProperty(Property property, URI value) {
        this.addMessageProperty(property, value.toString());
    }

    public synchronized void addMessageProperty(Property property, long value) {
        this.addMessageProperty(property, (RDFNode)this.getOuterEnvelopeGraph().createTypedLiteral(value));
    }

    public synchronized void addMessageProperty(Property property, int value) {
        this.addMessageProperty(property, (RDFNode)this.getOuterEnvelopeGraph().createTypedLiteral(value));
    }

    public synchronized void addMessageProperty(Property property, double value) {
        this.addMessageProperty(property, (RDFNode)this.getOuterEnvelopeGraph().createTypedLiteral(value));
    }

    public synchronized void addMessageProperty(Property property, float value) {
        this.addMessageProperty(property, (RDFNode)this.getOuterEnvelopeGraph().createTypedLiteral(value));
    }

    public synchronized void addMessageProperty(Property property, boolean value) {
        this.addMessageProperty(property, (RDFNode)this.getOuterEnvelopeGraph().createTypedLiteral(value));
    }

    public synchronized Dataset getMessageContent() {
        if (this.messageContent != null) {
            return RdfUtils.cloneDataset(this.messageContent);
        }
        Dataset newMsgContent = DatasetFactory.createGeneral();
        Iterator modelNames = this.completeDataset.listNames();
        List<String> envelopeGraphNames = this.getEnvelopeGraphURIs();
        List<String> contentGraphs = this.getContentGraphURIs();
        for (String modelName : contentGraphs) {
            newMsgContent.addNamedModel(modelName, this.completeDataset.getNamedModel(modelName));
            if (!this.graphSignatures.containsKey(modelName)) continue;
            Resource sig = this.graphSignatures.get(modelName);
            Model sigModel = ModelFactory.createDefaultModel();
            sigModel.add(sig.listProperties());
            newMsgContent.addNamedModel(sig.getURI(), sigModel);
        }
        this.messageContent = newMsgContent;
        return RdfUtils.cloneDataset(this.messageContent);
    }

    public synchronized List<AttachmentHolder> getAttachments() {
        if (this.attachmentHolders != null) {
            return this.attachmentHolders;
        }
        List<String> envelopeGraphUris = this.getEnvelopeGraphURIs();
        ArrayList<AttachmentHolder> newAttachmentHolders = new ArrayList<AttachmentHolder>();
        String queryString = "prefix rdfs:  <http://www.w3.org/2000/01/rdf-schema#>\nprefix xsd:   <http://www.w3.org/2001/XMLSchema#>\nprefix rdf:   <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nprefix won:   <https://w3id.org/won/core#>\nprefix msg:   <https://w3id.org/won/message#>\nprefix sig:   <http://icp.it-risk.iwvi.uni-koblenz.de/ontologies/signature.owl#>\n\nselect ?attachmentSigGraphUri ?attachmentGraphUri ?envelopeGraphUri ?attachmentDestinationUri where { \ngraph ?attachmentSigGraphUri {?attachmentSigGraphUri               a sig:Signature; \n              msg:signedGraph ?attachmentGraphUri.\n}\ngraph ?envelopeGraphUri {?envelopeGraphUri rdf:type msg:EnvelopeGraph.  \n    ?messageUri msg:hasAttachment ?attachmentData. \n?attachmentData msg:hasDestinationUri ?attachmentDestinationUri; \n                msg:hasAttachmentGraphUri ?attachmentGraphUri.\n}\n}";
        Query query = QueryFactory.create((String)queryString);
        QuerySolutionMap initialBinding = new QuerySolutionMap();
        initialBinding.add("messageUri", (RDFNode)new ResourceImpl(this.getMessageURI().toString()));
        try (QueryExecution queryExecution = QueryExecutionFactory.create((Query)query, (Dataset)this.completeDataset);){
            queryExecution.getContext().set(TDB.symUnionDefaultGraph, true);
            ResultSet result = queryExecution.execSelect();
            while (result.hasNext()) {
                QuerySolution solution = result.nextSolution();
                String envelopeGraphUri = solution.getResource("envelopeGraphUri").getURI();
                if (!envelopeGraphUris.contains(envelopeGraphUri)) {
                    this.logger.warn("found resource {} of type msg:EnvelopeGraph that is not the URI of an envelope graph in message {}", (Object)envelopeGraphUri, (Object)this.messageURI);
                    continue;
                }
                String sigGraphUri = solution.getResource("attachmentSigGraphUri").getURI().toString();
                String attachmentGraphUri = solution.getResource("attachmentGraphUri").getURI();
                String attachmentSigGraphUri = solution.getResource("attachmentSigGraphUri").getURI();
                String attachmentDestinationUri = solution.getResource("attachmentDestinationUri").getURI();
                Dataset attachmentDataset = DatasetFactory.createGeneral();
                attachmentDataset.addNamedModel(attachmentGraphUri, this.completeDataset.getNamedModel(attachmentGraphUri));
                attachmentDataset.addNamedModel(attachmentSigGraphUri, this.completeDataset.getNamedModel(attachmentSigGraphUri));
                AttachmentHolder attachmentHolder = new AttachmentHolder(URI.create(attachmentDestinationUri), attachmentDataset);
                newAttachmentHolders.add(attachmentHolder);
            }
        }
        this.attachmentHolders = newAttachmentHolders;
        return newAttachmentHolders;
    }

    private synchronized Model getOuterEnvelopeGraph() {
        if (this.outerEnvelopeGraph != null) {
            return this.outerEnvelopeGraph;
        }
        this.outerEnvelopeGraph = this.completeDataset.getNamedModel(this.getOuterEnvelopeGraphURI().toString());
        return this.outerEnvelopeGraph;
    }

    public synchronized URI getOuterEnvelopeGraphURI() {
        if (this.outerEnvelopeGraphURI != null) {
            return this.outerEnvelopeGraphURI;
        }
        this.getEnvelopeGraphs();
        return this.outerEnvelopeGraphURI;
    }

    public synchronized List<Model> getEnvelopeGraphs() {
        if (this.envelopeGraphs != null) {
            return this.envelopeGraphs;
        }
        ArrayList<Model> allEnvelopes = new ArrayList<Model>();
        this.envelopeGraphNames = new ArrayList<String>();
        this.contentGraphNames = new ArrayList<String>();
        this.graphSignatures = new HashMap<String, Resource>();
        URI currentMessageURI = null;
        this.outerEnvelopeGraph = null;
        HashSet<String> envelopesContainedInOthers = new HashSet<String>();
        HashSet<String> allEnvelopeGraphNames = new HashSet<String>();
        Iterator modelUriIterator = this.completeDataset.listNames();
        while (modelUriIterator.hasNext()) {
            Model envelopeGraph;
            String envelopeGraphUri = (String)modelUriIterator.next();
            if (this.isEnvelopeGraph(envelopeGraphUri, envelopeGraph = this.completeDataset.getNamedModel(envelopeGraphUri))) {
                this.envelopeGraphNames.add(envelopeGraphUri);
                allEnvelopeGraphNames.add(envelopeGraphUri);
                allEnvelopes.add(envelopeGraph);
                currentMessageURI = this.findMessageUri(envelopeGraph, envelopeGraphUri);
                List<String> containedEnvelopes = this.findContainedEnvelopeUris(envelopeGraph, envelopeGraphUri);
                if (containedEnvelopes.isEmpty()) {
                    this.innermostMessageURI = currentMessageURI;
                } else {
                    envelopesContainedInOthers.addAll(containedEnvelopes);
                }
                if (currentMessageURI != null) {
                    NodeIterator it = this.getContentGraphReferences(envelopeGraph, envelopeGraph.getResource(currentMessageURI.toString()));
                    while (it.hasNext()) {
                        RDFNode node = it.next();
                        this.contentGraphNames.add(node.asResource().toString());
                    }
                }
            }
            ResIterator it = envelopeGraph.listSubjectsWithProperty(RDF.type, (RDFNode)SFSIG.SIGNATURE);
            while (it.hasNext()) {
                Resource sig = (Resource)it.next();
                Resource signedGraph = sig.getPropertyResourceValue(WONMSG.signedGraph);
                this.graphSignatures.put(signedGraph.getURI(), sig);
            }
        }
        Sets.SetView candidatesForOuterEnvelope = Sets.symmetricDifference(allEnvelopeGraphNames, envelopesContainedInOthers);
        if (candidatesForOuterEnvelope.size() != 1) {
            throw new IllegalStateException(String.format("Message dataset must contain exactly one envelope graph that is not included in another one, but found %d", candidatesForOuterEnvelope.size()));
        }
        String outerEnvelopeUri = (String)candidatesForOuterEnvelope.iterator().next();
        this.outerEnvelopeGraphURI = URI.create(outerEnvelopeUri);
        this.outerEnvelopeGraph = this.completeDataset.getNamedModel(outerEnvelopeUri);
        this.envelopeGraphs = allEnvelopes;
        return Collections.unmodifiableList(allEnvelopes.stream().map(m -> RdfUtils.cloneModel(m)).collect(Collectors.toList()));
    }

    private synchronized URI findMessageUri(Model model, String modelUri) {
        RDFNode messageUriNode = RdfUtils.findOnePropertyFromResource(model, model.getResource(modelUri), RDFG.SUBGRAPH_OF);
        return URI.create(messageUriNode.asResource().getURI());
    }

    private synchronized List<String> findContainedEnvelopeUris(Model envelopeGraph, String envelopeGraphUri) {
        Resource envelopeGraphResource = envelopeGraph.getResource(envelopeGraphUri);
        StmtIterator it = envelopeGraphResource.listProperties(WONMSG.containsEnvelope);
        if (it.hasNext()) {
            ArrayList<String> ret = new ArrayList<String>();
            while (it.hasNext()) {
                ret.add(it.nextStatement().getObject().asResource().getURI());
            }
            return ret;
        }
        return Collections.emptyList();
    }

    public boolean isEnvelopeGraph(String modelUri, Model model) {
        return model.contains(model.getResource(modelUri), RDF.type, (RDFNode)WONMSG.EnvelopeGraph);
    }

    public synchronized List<String> getEnvelopeGraphURIs() {
        if (this.envelopeGraphs == null) {
            this.getEnvelopeGraphs();
        }
        return Collections.unmodifiableList(this.envelopeGraphNames);
    }

    public synchronized List<String> getContentGraphURIs() {
        if (this.envelopeGraphs == null) {
            this.getEnvelopeGraphs();
        }
        return Collections.unmodifiableList(this.contentGraphNames);
    }

    private synchronized NodeIterator getContentGraphReferences(Model model, Resource envelopeGraphResource) {
        return model.listObjectsOfProperty(envelopeGraphResource, WONMSG.content);
    }

    public synchronized URI getMessageURI() {
        if (this.messageURI == null) {
            this.messageURI = this.findMessageUri(this.getOuterEnvelopeGraph(), this.getOuterEnvelopeGraphURI().toString());
        }
        return this.messageURI;
    }

    public synchronized WonMessageType getMessageType() {
        if (this.messageType == null) {
            URI type = this.getEnvelopePropertyURIValue(WONMSG.messageType);
            this.messageType = WonMessageType.getWonMessageType(type);
        }
        return this.messageType;
    }

    public synchronized WonMessageDirection getEnvelopeType() {
        URI type;
        if (this.envelopeType == null && (type = this.getEnvelopePropertyURIValue(RDF.type)) != null) {
            this.envelopeType = WonMessageDirection.getWonMessageDirection(type);
        }
        return this.envelopeType;
    }

    public synchronized URI getSenderURI() {
        if (this.senderURI == null) {
            this.senderURI = this.getEnvelopePropertyURIValue(WONMSG.sender);
        }
        return this.senderURI;
    }

    public synchronized URI getSenderAtomURI() {
        if (this.senderAtomURI == null) {
            this.senderAtomURI = this.getEnvelopePropertyURIValue(WONMSG.senderAtom);
        }
        return this.senderAtomURI;
    }

    public synchronized URI getSenderNodeURI() {
        if (this.senderNodeURI == null) {
            this.senderNodeURI = this.getEnvelopePropertyURIValue(WONMSG.senderNode);
        }
        return this.senderNodeURI;
    }

    public synchronized URI getSenderSocketURI() {
        if (this.senderSocketURI == null) {
            this.senderSocketURI = this.getEnvelopePropertyURIValue(WONMSG.senderSocket);
        }
        return this.senderSocketURI;
    }

    public synchronized URI getRecipientURI() {
        if (this.recipientURI == null) {
            this.recipientURI = this.getEnvelopePropertyURIValue(WONMSG.recipient);
        }
        return this.recipientURI;
    }

    public synchronized URI getRecipientAtomURI() {
        if (this.recipientAtomURI == null) {
            this.recipientAtomURI = this.getEnvelopePropertyURIValue(WONMSG.recipientAtom);
        }
        return this.recipientAtomURI;
    }

    public synchronized URI getRecipientNodeURI() {
        if (this.recipientNodeURI == null) {
            this.recipientNodeURI = this.getEnvelopePropertyURIValue(WONMSG.recipientNode);
        }
        return this.recipientNodeURI;
    }

    public synchronized URI getRecipientSocketURI() {
        if (this.recipientSocketURI == null) {
            this.recipientSocketURI = this.getEnvelopePropertyURIValue(WONMSG.recipientSocket);
        }
        return this.recipientSocketURI;
    }

    public synchronized URI getHintTargetSocketURI() {
        if (this.hintTargetSocketURI == null) {
            this.hintTargetSocketURI = this.getEnvelopePropertyURIValue(WONMSG.hintTargetSocket);
        }
        return this.hintTargetSocketURI;
    }

    public synchronized URI getHintTargetAtomURI() {
        if (this.hintTargetAtomURI == null) {
            this.hintTargetAtomURI = this.getEnvelopePropertyURIValue(WONMSG.hintTargetAtom);
        }
        return this.hintTargetAtomURI;
    }

    public synchronized Double getHintScore() {
        if (this.hintScore == null) {
            this.hintScore = this.getEnvelopePropertyValue(WONMSG.hintScore, x -> x.isLiteral() ? Double.valueOf(x.asLiteral().getDouble()) : null);
        }
        return this.hintScore;
    }

    public synchronized List<URI> getInjectIntoConnectionURIs() {
        if (this.injectIntoConnections == null) {
            this.injectIntoConnections = this.getEnvelopePropertyURIValues(WONMSG.injectIntoConnection);
        }
        return this.injectIntoConnections;
    }

    public synchronized List<URI> getPreviousMessageURIs() {
        if (this.previousMessages == null) {
            this.previousMessages = this.getEnvelopePropertyURIValues(WONMSG.previousMessage);
        }
        return this.previousMessages;
    }

    public synchronized URI getIsResponseToMessageURI() {
        if (this.isResponseToMessageURI == null) {
            this.isResponseToMessageURI = this.getEnvelopePropertyURIValue(WONMSG.isResponseTo);
        }
        return this.isResponseToMessageURI;
    }

    public synchronized URI getIsRemoteResponseToMessageURI() {
        if (this.isRemoteResponseToMessageURI == null) {
            this.isRemoteResponseToMessageURI = this.getEnvelopePropertyURIValue(WONMSG.isRemoteResponseTo);
        }
        return this.isRemoteResponseToMessageURI;
    }

    public synchronized URI getCorrespondingRemoteMessageURI() {
        if (this.correspondingRemoteMessageURI == null) {
            this.correspondingRemoteMessageURI = this.getEnvelopePropertyURIValue(WONMSG.correspondingRemoteMessage);
        }
        return this.correspondingRemoteMessageURI;
    }

    public synchronized URI getForwardedMessageURI() {
        if (this.forwardedMessageURI == null) {
            this.forwardedMessageURI = this.getEnvelopePropertyURIValue(WONMSG.forwardedMessage);
        }
        return this.forwardedMessageURI;
    }

    public synchronized URI getInnermostMessageURI() {
        if (this.innermostMessageURI == null) {
            this.getEnvelopeGraphs();
        }
        return this.innermostMessageURI;
    }

    public synchronized WonMessageType getIsResponseToMessageType() {
        URI typeURI;
        if (this.isResponseToMessageType == null && (typeURI = this.getEnvelopePropertyURIValue(WONMSG.isResponseToMessageType)) != null) {
            this.isResponseToMessageType = WonMessageType.getWonMessageType(typeURI);
        }
        return this.isResponseToMessageType;
    }

    public synchronized URI getEnvelopePropertyURIValue(URI propertyURI) {
        Property property = this.completeDataset.getDefaultModel().createProperty(propertyURI.toString());
        return this.getEnvelopePropertyURIValue(property);
    }

    public synchronized URI getEnvelopePropertyURIValue(Property property) {
        Model currentEnvelope = this.getOuterEnvelopeGraph();
        URI currentEnvelopeUri = this.getOuterEnvelopeGraphURI();
        while (currentEnvelope != null) {
            URI currentMessageURI = this.findMessageUri(currentEnvelope, currentEnvelopeUri.toString());
            StmtIterator it = currentEnvelope.listStatements(currentEnvelope.getResource(currentMessageURI.toString()), property, (RDFNode)null);
            if (it.hasNext()) {
                return URI.create(it.nextStatement().getObject().asResource().toString());
            }
            currentEnvelopeUri = RdfUtils.findFirstObjectUri(currentEnvelope, WONMSG.containsEnvelope, null, true, true);
            currentEnvelope = null;
            if (currentEnvelopeUri == null) continue;
            currentEnvelope = this.completeDataset.getNamedModel(currentEnvelopeUri.toString());
        }
        return null;
    }

    public synchronized <T> T getEnvelopePropertyValue(Property property, Function<RDFNode, T> mapper) {
        Model currentEnvelope = this.getOuterEnvelopeGraph();
        URI currentEnvelopeUri = this.getOuterEnvelopeGraphURI();
        while (currentEnvelope != null) {
            URI currentMessageURI = this.findMessageUri(currentEnvelope, currentEnvelopeUri.toString());
            StmtIterator it = currentEnvelope.listStatements(currentEnvelope.getResource(currentMessageURI.toString()), property, (RDFNode)null);
            if (it.hasNext()) {
                return mapper.apply(it.nextStatement().getObject());
            }
            currentEnvelopeUri = RdfUtils.findFirstObjectUri(currentEnvelope, WONMSG.containsEnvelope, null, true, true);
            currentEnvelope = null;
            if (currentEnvelopeUri == null) continue;
            currentEnvelope = this.completeDataset.getNamedModel(currentEnvelopeUri.toString());
        }
        return null;
    }

    private synchronized URI getEnvelopeSubjectURIValue(Property property, RDFNode object) {
        for (Model envelopeGraph : this.getEnvelopeGraphs()) {
            URI val = RdfUtils.findFirstSubjectUri(envelopeGraph, property, object, true, true);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    private synchronized List<URI> getEnvelopePropertyURIValues(Property property) {
        ArrayList<URI> values = new ArrayList<URI>();
        Model currentEnvelope = this.getOuterEnvelopeGraph();
        URI currentEnvelopeUri = this.getOuterEnvelopeGraphURI();
        while (currentEnvelope != null) {
            URI currentMessageURI = this.findMessageUri(currentEnvelope, currentEnvelopeUri.toString());
            StmtIterator it = currentEnvelope.listStatements(currentEnvelope.getResource(currentMessageURI.toString()), property, (RDFNode)null);
            while (it.hasNext()) {
                values.add(URI.create(it.nextStatement().getObject().asResource().toString()));
            }
            currentEnvelopeUri = RdfUtils.findFirstObjectUri(currentEnvelope, WONMSG.containsEnvelope, null, true, true);
            currentEnvelope = null;
            if (currentEnvelopeUri == null) continue;
            currentEnvelope = this.completeDataset.getNamedModel(currentEnvelopeUri.toString());
        }
        return values;
    }

    public static class AttachmentHolder {
        private URI destinationUri;
        private Dataset attachmentDataset;

        public AttachmentHolder(URI destinationUri, Dataset attachmentDataset) {
            this.destinationUri = destinationUri;
            this.attachmentDataset = attachmentDataset;
        }

        public URI getDestinationUri() {
            return this.destinationUri;
        }

        public Dataset getAttachmentDataset() {
            return this.attachmentDataset;
        }
    }

    public class AttachmentMetaData {
        URI attachmentGraphUri;
        URI destinationUri;

        AttachmentMetaData(URI attachmentGraphUri, URI destinationUri) {
            this.attachmentGraphUri = attachmentGraphUri;
            this.destinationUri = destinationUri;
        }

        public URI getAttachmentGraphUri() {
            return this.attachmentGraphUri;
        }

        public URI getDestinationUri() {
            return this.destinationUri;
        }
    }
}

