/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.jms;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.spi.Synchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import won.protocol.jms.MessagingService;

public class MessagingServiceImpl<T>
implements ApplicationContextAware,
MessagingService,
CamelContextAware {
    private static final long DEFAULT_JMS_EXPIRATION_TIME = 0L;
    private CamelContext camelContext;
    private ProducerTemplate producerTemplate;
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ApplicationContext applicationContext;

    public synchronized ListenableFuture sendInOutMessageGeneric(Map properties, Map headers, Object body, String endpoint) {
        DefaultExchange exchange = new DefaultExchange(this.getCamelContext());
        Endpoint ep = this.getCamelContext().getEndpoint(endpoint);
        if (properties != null && properties.containsKey("methodName")) {
            exchange.setProperty("methodName", properties.get("methodName"));
        }
        if (headers != null) {
            exchange.getIn().setHeaders(headers);
        }
        exchange.getIn().setBody(body);
        exchange.setPattern(ExchangePattern.InOut);
        final SettableFuture result = SettableFuture.create();
        logger.debug("sending inout message");
        this.producerTemplate.asyncCallback(ep, (Exchange)exchange, new Synchronization(){

            public void onComplete(Exchange exchange) {
                Object resultObject = exchange.getOut().getBody();
                result.set(resultObject);
            }

            public void onFailure(Exchange exchange) {
                if (exchange.getException() != null) {
                    logger.warn("caught exception while sending jms message", (Throwable)exchange.getException());
                }
                result.cancel(true);
            }
        });
        return result;
    }

    @Override
    public void inspectMessage(Exchange exchange) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        this.inspectProperties(exchange);
        this.inspectHeaders(exchange);
        if (exchange.getIn().getBody() != null) {
            logger.debug(exchange.getIn().getBody().toString());
        }
    }

    @Override
    public void inspectProperties(Exchange exchange) {
        Map properties = exchange.getProperties();
        Iterator iter = properties.entrySet().iterator();
        if (logger.isDebugEnabled()) {
            logger.debug("WIRETAP: properties size: " + properties.size());
            while (iter.hasNext()) {
                Map.Entry pairs = iter.next();
                logger.debug("key: " + pairs.getKey() + " value: " + pairs.getValue());
            }
        }
    }

    public void inspectBody(Exchange exchange) {
        exchange.getIn().getBody();
    }

    @Override
    public void inspectHeaders(Exchange exchange) {
        Map headers = exchange.getIn().getHeaders();
        Iterator iter = headers.entrySet().iterator();
        if (logger.isDebugEnabled()) {
            logger.debug("WIRETAP: headers size: " + headers.size());
            while (iter.hasNext()) {
                Map.Entry pairs = iter.next();
                if (pairs.getValue() == null) continue;
                logger.debug("key: " + pairs.getKey() + " value: " + pairs.getValue());
            }
        }
    }

    @Override
    public synchronized void sendInOnlyMessage(Map properties, Map headers, Object body, String endpoint) {
        DefaultExchange exchange = new DefaultExchange(this.getCamelContext());
        exchange.setPattern(ExchangePattern.InOnly);
        Endpoint ep = this.getCamelContext().getEndpoint(endpoint);
        if (properties != null) {
            if (properties.containsKey("methodName")) {
                exchange.setProperty("methodName", properties.get("methodName"));
            }
            if (properties.containsKey("protocol")) {
                exchange.setProperty("protocol", properties.get("protocol"));
            }
        }
        if (headers != null) {
            exchange.getIn().setHeaders(headers);
        }
        exchange.getIn().setBody(body);
        this.producerTemplate.send(ep, (Exchange)exchange);
        if (exchange.getException() != null) {
            logger.warn("caught exception while sending jms message", (Throwable)exchange.getException());
        }
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setProducerTemplate(ProducerTemplate producerTemplate) {
        this.producerTemplate = producerTemplate;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

