/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.jms;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathParser;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.HttpClientErrorException;
import won.protocol.jms.ActiveMQServiceImpl;
import won.protocol.jms.MatcherActiveMQService;
import won.protocol.model.ProtocolType;
import won.protocol.util.RdfUtils;
import won.protocol.vocabulary.WON;

public class MatcherActiveMQServiceImpl
extends ActiveMQServiceImpl
implements MatcherActiveMQService {
    private List<String> matcherProtocolTopicList;
    private String pathInformation;
    private static final String PATH_MATCHER_PROTOCOL_OUT_ATOM_CREATED = "<" + WON.supportsWonProtocolImpl + ">/<" + WON.atomCreatedTopic + ">";
    private static final String PATH_MATCHER_PROTOCOL_OUT_ATOM_ACTIVATED = "<" + WON.supportsWonProtocolImpl + ">/<" + WON.atomActivatedTopic + ">";
    private static final String PATH_MATCHER_PROTOCOL_OUT_ATOM_DEACTIVATED = "<" + WON.supportsWonProtocolImpl + ">/<" + WON.atomDeactivatedTopic + ">";
    private static final String PATH_MATCHER_PROTOCOL_QUEUE_NAME = "<" + WON.supportsWonProtocolImpl + ">/<" + WON.matcherQueue + ">";

    public MatcherActiveMQServiceImpl(ProtocolType type) {
        super(type);
        this.queueNamePath = PATH_MATCHER_PROTOCOL_QUEUE_NAME;
        this.matcherProtocolTopicList = new ArrayList<String>();
        this.matcherProtocolTopicList.add(PATH_MATCHER_PROTOCOL_OUT_ATOM_ACTIVATED);
        this.matcherProtocolTopicList.add(PATH_MATCHER_PROTOCOL_OUT_ATOM_CREATED);
        this.matcherProtocolTopicList.add(PATH_MATCHER_PROTOCOL_OUT_ATOM_DEACTIVATED);
    }

    @Override
    public final Set<String> getMatcherProtocolTopicNamesWithResource(URI resourceURI) {
        HashSet<String> activeMQMatcherProtocolTopicNames = new HashSet<String>();
        for (int i = 0; i < this.matcherProtocolTopicList.size(); ++i) {
            try {
                Path path = PathParser.parse((String)this.matcherProtocolTopicList.get(i), (PrefixMapping)PrefixMapping.Standard);
                activeMQMatcherProtocolTopicNames.add(RdfUtils.getStringPropertyForPropertyPath(this.linkedDataSource.getDataForResource(resourceURI), resourceURI, path));
                continue;
            }
            catch (HttpClientErrorException e) {
                if (e.getStatusCode() == HttpStatus.NOT_FOUND) {
                    return null;
                }
                throw e;
            }
        }
        return activeMQMatcherProtocolTopicNames;
    }
}

