/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.jms;

import java.net.URI;
import javax.jms.ConnectionFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQSslConnectionFactory;
import org.apache.activemq.camel.component.ActiveMQComponent;
import org.apache.camel.Component;
import org.apache.camel.component.jms.JmsConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.connection.CachingConnectionFactory;
import won.cryptography.ssl.MessagingContext;
import won.protocol.jms.WonJmsConfiguration;
import won.protocol.model.MessagingType;

public class BrokerComponentFactory {
    Logger logger = LoggerFactory.getLogger(this.getClass());

    private synchronized Component getBrokerComponent(URI brokerURI, MessagingType type) {
        this.logger.info("establishing activemq connection for brokerUri {} (with specified type)", (Object)brokerURI);
        ActiveMQConnectionFactory activeMQConnectionFactory = new ActiveMQConnectionFactory(brokerURI + "?jms.prefetchPolicy.all=50");
        return this.getBrokerComponent(type, activeMQConnectionFactory);
    }

    private synchronized Component getBrokerComponent(URI brokerURI, MessagingType type, KeyManager keyManager, TrustManager trustManager) {
        this.logger.info("establishing activemq ssl connection for brokerUri {} (with specified type, keyManager, and TrustManager)", (Object)brokerURI);
        ActiveMQSslConnectionFactory activeMQConnectionFactory = new ActiveMQSslConnectionFactory(brokerURI + "?jms.prefetchPolicy.all=50");
        activeMQConnectionFactory.setKeyAndTrustManagers(new KeyManager[]{keyManager}, new TrustManager[]{trustManager}, null);
        return this.getBrokerComponent(type, (ActiveMQConnectionFactory)activeMQConnectionFactory);
    }

    public synchronized Component getBrokerComponent(URI brokerURI, MessagingType type, MessagingContext messagingContext) {
        this.logger.info("establishing activemq connection for brokerUri {}", (Object)brokerURI);
        X509KeyManager keyManager = null;
        TrustManager trustManager = null;
        try {
            keyManager = messagingContext.getClientKeyManager();
            trustManager = messagingContext.getClientTrustManager();
        }
        catch (Exception e) {
            this.logger.error("Key- or Trust- manager initialization problem");
        }
        if (keyManager == null || trustManager == null) {
            return this.getBrokerComponent(brokerURI, type);
        }
        return this.getBrokerComponent(brokerURI, type, keyManager, trustManager);
    }

    private synchronized Component getBrokerComponent(MessagingType type, ActiveMQConnectionFactory connectionFactory) {
        CachingConnectionFactory cachingConnectionFactory = (CachingConnectionFactory)this.configureCachingConnectionFactory(connectionFactory);
        WonJmsConfiguration jmsConfiguration = new WonJmsConfiguration((ConnectionFactory)cachingConnectionFactory);
        switch (type) {
            case Queue: {
                jmsConfiguration.configureJmsConfigurationForQueues();
                break;
            }
            case Topic: {
                jmsConfiguration.configureJmsConfigurationForTopics();
            }
        }
        ActiveMQComponent activeMQComponent = ActiveMQComponent.activeMQComponent();
        activeMQComponent.setConfiguration((JmsConfiguration)jmsConfiguration);
        return activeMQComponent;
    }

    public synchronized ConnectionFactory configureCachingConnectionFactory(ActiveMQConnectionFactory connectionFactory) {
        connectionFactory.setAlwaysSyncSend(false);
        connectionFactory.setDisableTimeStampsByDefault(true);
        CachingConnectionFactory cachingConnectionFactory = new CachingConnectionFactory((ConnectionFactory)connectionFactory);
        cachingConnectionFactory.setCacheConsumers(true);
        cachingConnectionFactory.setCacheProducers(true);
        return cachingConnectionFactory;
    }
}

