/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.jms;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import org.apache.activemq.camel.component.ActiveMQComponent;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.RoutesBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import won.cryptography.ssl.MessagingContext;
import won.protocol.exception.CamelConfigurationFailedException;
import won.protocol.jms.AtomProtocolCamelConfigurator;
import won.protocol.jms.BrokerComponentFactory;
import won.protocol.model.MessagingType;

public abstract class AtomBasedCamelConfiguratorImpl
implements AtomProtocolCamelConfigurator {
    private BiMap<URI, String> endpointMap = HashBiMap.create();
    protected BiMap<URI, String> brokerComponentMap = HashBiMap.create();
    private String componentName;
    private final String localComponentName = "seda";
    private String vmComponentName;
    private CamelContext camelContext;
    private MessagingContext messagingContext;
    @Autowired
    protected BrokerComponentFactory brokerComponentFactory;
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public synchronized String configureCamelEndpointForAtomUri(URI wonNodeURI, URI brokerUri, String atomProtocolQueueName) {
        String brokerComponentName = this.setupBrokerComponentName(brokerUri);
        if (!brokerComponentName.contains("brokerUri")) {
            this.addCamelComponentForWonNodeBroker(brokerUri, brokerComponentName);
        }
        String endpoint = brokerComponentName + ":queue:" + atomProtocolQueueName;
        this.endpointMap.put((Object)wonNodeURI, (Object)endpoint);
        logger.info("endpoint of wonNodeURI {} is {}", (Object)wonNodeURI, this.endpointMap.get((Object)wonNodeURI));
        return endpoint;
    }

    @Override
    public synchronized String setupBrokerComponentName(URI brokerUri) {
        return this.componentName + brokerUri.toString().replaceAll("[/:]", "");
    }

    @Override
    public synchronized void addCamelComponentForWonNodeBroker(URI brokerUri, String brokerComponentName) {
        if (this.camelContext.getComponent(brokerComponentName) == null) {
            ActiveMQComponent activeMQComponent = (ActiveMQComponent)this.brokerComponentFactory.getBrokerComponent(brokerUri, MessagingType.Queue, this.messagingContext);
            logger.info("adding activemqComponent for brokerUri {}", (Object)brokerUri);
            this.camelContext.addComponent(brokerComponentName, (Component)activeMQComponent);
            try {
                activeMQComponent.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.brokerComponentMap.put((Object)brokerUri, (Object)brokerComponentName);
    }

    @Override
    public synchronized void addRouteForEndpoint(String startingEndpoint, URI brokerUri) throws CamelConfigurationFailedException {
        if (this.getCamelContext().getRoute(startingEndpoint) == null) {
            try {
                this.getCamelContext().addRoutes(this.createRoutesBuilder(startingEndpoint, brokerUri));
            }
            catch (Exception e) {
                throw new CamelConfigurationFailedException("adding route to camel context failed", e);
            }
        }
    }

    protected abstract RoutesBuilder createRoutesBuilder(String var1, URI var2);

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void setMessagingContext(MessagingContext messagingContext) {
        this.messagingContext = messagingContext;
    }

    public MessagingContext getMessagingContext() {
        return this.messagingContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public String getEndpoint(URI nodeUri) {
        return (String)this.endpointMap.get((Object)nodeUri);
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public String getBrokerComponentNameWithBrokerUri(URI brokerUri) {
        return (String)this.brokerComponentMap.get((Object)brokerUri);
    }
}

