/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.jms;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.query.Dataset;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.HttpClientErrorException;
import won.protocol.jms.ActiveMQService;
import won.protocol.model.ProtocolType;
import won.protocol.util.RdfUtils;
import won.protocol.util.linkeddata.LinkedDataSource;
import won.protocol.util.linkeddata.WonLinkedDataUtils;
import won.protocol.vocabulary.WON;

public class ActiveMQServiceImpl
implements ActiveMQService {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String PATH_OWNER_PROTOCOL_QUEUE_NAME = "<" + WON.supportsWonProtocolImpl + ">/<" + WON.ownerQueue + ">";
    private static final String PATH_ATOM_PROTOCOL_QUEUE_NAME = "<" + WON.supportsWonProtocolImpl + ">/<" + WON.nodeQueue + ">";
    private static final String PATH_BROKER_URI = "<" + WON.supportsWonProtocolImpl + ">/<" + WON.brokerUri + ">";
    protected String queueNamePath;
    private List<String> matcherProtocolTopicList;
    private ProtocolType protocolType;
    private String pathInformation;
    @Autowired
    @Qualifier(value="default")
    protected LinkedDataSource linkedDataSource;

    public ActiveMQServiceImpl(ProtocolType type) {
        switch (type) {
            case OwnerProtocol: {
                this.queueNamePath = PATH_OWNER_PROTOCOL_QUEUE_NAME;
                break;
            }
            case AtomProtocol: {
                this.queueNamePath = PATH_ATOM_PROTOCOL_QUEUE_NAME;
                break;
            }
        }
        this.protocolType = type;
    }

    @Override
    public final String getProtocolQueueNameWithResource(URI resourceUri) {
        String activeMQOwnerProtocolQueueName = null;
        try {
            logger.debug("trying to get queue name prototol type {} on resource {}", (Object)this.protocolType, (Object)resourceUri);
            Path path = PathParser.parse((String)this.queueNamePath, (PrefixMapping)PrefixMapping.Standard);
            Dataset resourceDataset = this.linkedDataSource.getDataForResource(resourceUri);
            activeMQOwnerProtocolQueueName = RdfUtils.getStringPropertyForPropertyPath(resourceDataset, resourceUri, path);
            if (activeMQOwnerProtocolQueueName != null) {
                return activeMQOwnerProtocolQueueName;
            }
            logger.debug("could not to get queue name from resource {}, trying to obtain won node URI", (Object)resourceUri);
            URI wonNodeUri = WonLinkedDataUtils.getWonNodeURIForAtomOrConnection(resourceUri, resourceDataset);
            activeMQOwnerProtocolQueueName = RdfUtils.getStringPropertyForPropertyPath(this.linkedDataSource.getDataForResource(wonNodeUri), wonNodeUri, path);
            logger.debug("returning queue name {}", (Object)activeMQOwnerProtocolQueueName);
            return activeMQOwnerProtocolQueueName;
        }
        catch (HttpClientErrorException e) {
            logger.warn("Could not obtain data for URI:{}", (Object)resourceUri);
            if (e.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public final URI getBrokerEndpoint(URI resourceUri) {
        logger.debug("obtaining broker URI for node {}", (Object)resourceUri);
        URI activeMQEndpoint = null;
        try {
            logger.debug("trying to get broker endpoint for {} on resource {}", (Object)this.protocolType, (Object)resourceUri);
            Path path = PathParser.parse((String)PATH_BROKER_URI, (PrefixMapping)PrefixMapping.Standard);
            Dataset resourceDataset = this.linkedDataSource.getDataForResource(resourceUri);
            logger.debug("ResourceModel for {}: {}", (Object)resourceUri, (Object)resourceDataset);
            activeMQEndpoint = RdfUtils.getURIPropertyForPropertyPath(resourceDataset, resourceUri, path);
            if (activeMQEndpoint != null) {
                return activeMQEndpoint;
            }
            logger.debug("could not to get broker URI from resource {}, trying to obtain won node URI", (Object)resourceUri);
            URI wonNodeUri = WonLinkedDataUtils.getWonNodeURIForAtomOrConnection(resourceUri, resourceDataset);
            logger.debug("wonNodeUri: {}", (Object)wonNodeUri);
            resourceDataset = this.linkedDataSource.getDataForResource(wonNodeUri);
            activeMQEndpoint = RdfUtils.getURIPropertyForPropertyPath(resourceDataset, wonNodeUri, path);
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw e;
        }
        logger.debug("returning brokerUri {} for resourceUri {} ", (Object)activeMQEndpoint, (Object)resourceUri);
        return activeMQEndpoint;
    }

    public Set<String> getMatcherProtocolTopicNamesWithResource(URI resourceURI) {
        HashSet<String> activeMQMatcherProtocolTopicNames = new HashSet<String>();
        resourceURI = URI.create(resourceURI.toString() + this.pathInformation);
        for (int i = 0; i < this.matcherProtocolTopicList.size(); ++i) {
            try {
                Path path = PathParser.parse((String)this.matcherProtocolTopicList.get(i), (PrefixMapping)PrefixMapping.Standard);
                activeMQMatcherProtocolTopicNames.add(RdfUtils.getStringPropertyForPropertyPath(this.linkedDataSource.getDataForResource(resourceURI), resourceURI, path));
                continue;
            }
            catch (HttpClientErrorException e) {
                if (e.getStatusCode() == HttpStatus.NOT_FOUND) {
                    return null;
                }
                throw e;
            }
        }
        return activeMQMatcherProtocolTopicNames;
    }

    public void setLinkedDataSource(LinkedDataSource linkedDataSource) {
        this.linkedDataSource = linkedDataSource;
    }
}

