/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.exception;

import java.text.MessageFormat;
import won.protocol.exception.DataIntegrityException;

public class IncorrectPropertyCountException
extends DataIntegrityException {
    private int expectedCount;
    private int actualCount;

    public IncorrectPropertyCountException(int expectedCount, int actualCount) {
        this(MessageFormat.format("Incorrect property count, expected: {0}, actual: {1} (at least)", expectedCount, actualCount), expectedCount, actualCount);
    }

    public IncorrectPropertyCountException(String message, int expectedCount, int actualCount) {
        super(message + ", expected: " + expectedCount + ", actual: " + actualCount);
        this.expectedCount = expectedCount;
        this.actualCount = actualCount;
    }

    public IncorrectPropertyCountException(String message, Throwable cause, int expectedCount, int actualCount) {
        super(message + ", expected: " + expectedCount + ", actual: " + actualCount, cause);
        this.expectedCount = expectedCount;
        this.actualCount = actualCount;
    }

    public IncorrectPropertyCountException(Throwable cause, int expectedCount, int actualCount) {
        super(cause);
        this.expectedCount = expectedCount;
        this.actualCount = actualCount;
    }

    public IncorrectPropertyCountException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace, int expectedCount, int actualCount) {
        super(message + ", expected: " + expectedCount + ", actual: " + actualCount, cause, enableSuppression, writableStackTrace);
        this.expectedCount = expectedCount;
        this.actualCount = actualCount;
    }

    public int getExpectedCount() {
        return this.expectedCount;
    }

    public int getActualCount() {
        return this.actualCount;
    }
}

