/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.exception;

import java.net.URI;
import java.text.MessageFormat;
import won.protocol.exception.WonProtocolException;

public class ConnectionAlreadyExistsException
extends WonProtocolException {
    private URI connectionURI;
    private URI fromAtomURI;
    private URI toAtomURI;

    public ConnectionAlreadyExistsException(URI connectionURI, URI fromAtomURI, URI toAtomURI) {
        super(MessageFormat.format("The connection between atoms {0} and {1} that you wanted to connect already exists with this URI: {2}", fromAtomURI.toString(), toAtomURI, connectionURI));
        this.connectionURI = connectionURI;
        this.fromAtomURI = fromAtomURI;
        this.toAtomURI = toAtomURI;
    }

    public URI getFromAtomURI() {
        return this.fromAtomURI;
    }

    public URI getToAtomURI() {
        return this.toAtomURI;
    }

    public URI getConnectionURI() {
        return this.connectionURI;
    }
}

