/*
 * Decompiled with CFR 0.152.
 */
package won.protocol;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class Config {
    public static final String SYSPROPKEY_WON_CONFIG_DIR = "WON_CONFIG_DIR";
    public static final String PROPERTIES_FILE_MATCHER = "matcher.properties";

    public static InputStream getInputStreamForConfigFile(String filename) throws FileNotFoundException {
        String configDir = System.getProperty(SYSPROPKEY_WON_CONFIG_DIR);
        if (configDir == null) {
            throw new IllegalArgumentException("system property 'WON_CONFIG_DIR' should point to the configuration dir but is null");
        }
        File configDirFile = new File(configDir);
        if (!configDirFile.exists()) {
            throw new IllegalArgumentException("won config dir '" + configDir + "' defined by system property '" + SYSPROPKEY_WON_CONFIG_DIR + "' does not exist");
        }
        if (!configDirFile.canRead()) {
            throw new IllegalArgumentException("won config dir '" + configDir + "' defined by system property '" + SYSPROPKEY_WON_CONFIG_DIR + "' is not readable");
        }
        File configFile = new File(configDirFile, filename);
        if (!configFile.exists()) {
            throw new IllegalArgumentException("won config file '" + filename + " expected at  dir '" + configDir + "' defined by system property '" + SYSPROPKEY_WON_CONFIG_DIR + "' does not exist");
        }
        if (!configFile.canRead()) {
            throw new IllegalArgumentException("won config file '" + filename + " expected at  dir '" + configDir + "' defined by system property '" + SYSPROPKEY_WON_CONFIG_DIR + "' is not readable");
        }
        return new FileInputStream(configFile);
    }
}

