/*
 * Decompiled with CFR 0.152.
 */
package won.monitoring.simon;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import org.javasimon.Sample;
import org.javasimon.Simon;
import org.javasimon.SimonManager;
import org.javasimon.Stopwatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.cellprocessor.Optional;
import org.supercsv.cellprocessor.constraint.NotNull;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.CsvMapWriter;
import org.supercsv.io.ICsvMapWriter;
import org.supercsv.prefs.CsvPreference;
import won.monitoring.AbstractFileOutputRecorder;
import won.monitoring.simon.SimonVisitor;
import won.monitoring.simon.SimonVisitors;

public class SimonCsvStatisticsRecorder
extends AbstractFileOutputRecorder {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static String[] header = new String[]{"Name", "Type", "Counter", "Total", "Min", "Max", "Mean", "StdDev", "FirstUsage", "LastUsage", "LastReset", "Note"};

    private static CellProcessor[] getProcessors() {
        CellProcessor[] processors = new CellProcessor[]{new NotNull(), new NotNull(), new Optional(), new Optional(), new Optional(), new Optional(), new Optional(), new Optional(), new NotNull(), new NotNull(), new NotNull(), new Optional()};
        return processors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordMonitoringStatistics() {
        CsvMapWriter mapWriter = null;
        try {
            mapWriter = new CsvMapWriter((Writer)new FileWriter(this.createOutFileObject()), CsvPreference.STANDARD_PREFERENCE);
            CellProcessor[] processors = SimonCsvStatisticsRecorder.getProcessors();
            mapWriter.writeHeader(header);
            CsvSimonVisitor visitor = new CsvSimonVisitor((ICsvMapWriter)mapWriter);
            SimonVisitors.visitTree(SimonManager.getRootSimon(), visitor);
        }
        catch (IOException e) {
            logger.warn("could not write simon statistics", (Throwable)e);
        }
        finally {
            if (mapWriter != null) {
                try {
                    mapWriter.close();
                }
                catch (IOException e) {
                    logger.warn("could not close writer", (Throwable)e);
                }
            }
        }
    }

    private class CsvSimonVisitor
    implements SimonVisitor {
        private ICsvMapWriter mapWriter;

        public CsvSimonVisitor(ICsvMapWriter mapWriter) {
            this.mapWriter = mapWriter;
        }

        @Override
        public void visit(Simon simon) throws IOException {
            HashMap<String, Object> values = new HashMap<String, Object>(header.length);
            Sample sample = simon.sample();
            values.put(header[0], sample.getName());
            values.put(header[1], simon.getClass().getName());
            if (simon instanceof Stopwatch) {
                Stopwatch stopwatch = (Stopwatch)simon;
                values.put(header[2], stopwatch.getCounter());
                values.put(header[3], stopwatch.getTotal());
                values.put(header[4], stopwatch.getMin());
                values.put(header[5], stopwatch.getMax());
                values.put(header[6], stopwatch.getMean());
                values.put(header[7], stopwatch.getStandardDeviation());
            }
            values.put(header[8], simon.getFirstUsage());
            values.put(header[9], simon.getLastUsage());
            values.put(header[10], simon.getLastReset());
            values.put(header[11], simon.getNote());
            this.mapWriter.write(values, header, SimonCsvStatisticsRecorder.getProcessors());
        }
    }
}

