/*
 * Decompiled with CFR 0.152.
 */
package won.monitoring;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.monitoring.MonitoringResetter;
import won.monitoring.MonitoringStatisticsRecorder;

public class MonitoringStatisticsRecorderTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private List<MonitoringStatisticsRecorder> monitoringStatisticsRecorders;
    private boolean resetMonitorAfterRecording;
    private MonitoringResetter monitoringResetter;

    @Override
    public void run() {
        if (this.monitoringStatisticsRecorders == null || this.monitoringStatisticsRecorders.isEmpty()) {
            logger.debug("No recorders configured, not recording any monitoring statistics, ");
            return;
        }
        for (MonitoringStatisticsRecorder recorder : this.monitoringStatisticsRecorders) {
            logger.debug("running monitoring stats recorder '{}'", (Object)recorder.getRecorderName());
            recorder.recordMonitoringStatistics();
            logger.debug("done monitoring stats recorder '{}'", (Object)recorder.getRecorderName());
        }
        if (this.resetMonitorAfterRecording) {
            if (this.monitoringResetter != null) {
                logger.debug("resetting the monitor");
                this.monitoringResetter.resetMonitoringStatistics();
            } else {
                logger.warn("MonitoringStatisticsRecorderTask is configured to reset the monitor after recording, but no MonitoringResetter has been configured");
            }
        }
    }

    public void setMonitoringStatisticsRecorders(List<MonitoringStatisticsRecorder> monitoringStatisticsRecorders) {
        this.monitoringStatisticsRecorders = monitoringStatisticsRecorders;
    }

    public void setResetMonitorAfterRecording(boolean resetMonitorAfterRecording) {
        this.resetMonitorAfterRecording = resetMonitorAfterRecording;
    }

    public void setMonitoringResetter(MonitoringResetter monitoringResetter) {
        this.monitoringResetter = monitoringResetter;
    }
}

