/*
 * Decompiled with CFR 0.152.
 */
package won.monitoring;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.monitoring.AbstractRecorder;

public abstract class AbstractFileOutputRecorder
extends AbstractRecorder {
    private static final String TEMPDIR_PREFIX = "monitoringStatsCSV";
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private File outputDirectory;
    private String outfilePattern = "'monitoring-'yyyy-MM-dd'T'HH-mm-ss'.log'";

    protected String createOutFilename() {
        SimpleDateFormat format = new SimpleDateFormat(this.outfilePattern);
        return format.format(new Date());
    }

    protected File createOutFileObject() throws IOException {
        boolean success;
        if (this.outputDirectory == null) {
            this.outputDirectory = Files.createTempDirectory(TEMPDIR_PREFIX, new FileAttribute[0]).toFile();
            logger.info("created temporary directory for monitoring output: {}", (Object)this.outputDirectory);
        } else if (!this.outputDirectory.exists() && (success = this.outputDirectory.createNewFile())) {
            logger.info("created temporary directory for monitoring output: {}", (Object)this.outputDirectory);
        }
        File newOutfile = new File(this.outputDirectory, this.createOutFilename());
        logger.debug("writing monitoring statistics to file {}", (Object)newOutfile);
        return newOutfile;
    }

    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    protected String getOutfilePattern() {
        return this.outfilePattern;
    }

    public void setOutfilePattern(String outfilePattern) {
        this.outfilePattern = outfilePattern;
    }
}

