/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.ssl;

import java.lang.invoke.MethodHandles;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.cryptography.service.TrustStoreService;
import won.cryptography.ssl.AliasGenerator;

public class TOLUStrategy
implements TrustStrategy {
    private TrustStoreService trustStoreService;
    private AliasGenerator aliasGenerator;
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void setTrustStoreService(TrustStoreService trustStoreService) {
        this.trustStoreService = trustStoreService;
    }

    public void setAliasGenerator(AliasGenerator aliasGenerator) {
        this.aliasGenerator = aliasGenerator;
    }

    public boolean isTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        if (x509Certificates == null || x509Certificates.length < 1) {
            return false;
        }
        X509Certificate cert = x509Certificates[0];
        String alias = this.aliasGenerator.generateAlias(cert);
        if (this.trustStoreService.isCertKnown(cert)) {
            return true;
        }
        try {
            this.trustStoreService.addCertificate(alias, cert, true);
            logger.info("Certificate is added based on TOLU and from now on it is trusted!");
            return true;
        }
        catch (Exception e) {
            logger.warn("Certificate could not be added as trusted for TOLU for alias " + alias, (Throwable)e);
            return false;
        }
    }
}

