/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.ssl;

import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.apache.http.ssl.TrustStrategy;
import won.cryptography.service.TrustStoreService;
import won.cryptography.service.keystore.KeyStoreService;
import won.cryptography.ssl.KeyManagerWrapperWithKeyServiceAndStrategy;
import won.cryptography.ssl.TrustManagerWrapperWithStrategy;
import won.cryptography.ssl.TrustManagerWrapperWithTrustService;

public class MessagingContext {
    private X509KeyManager keyManager;
    private X509TrustManager trustManager;

    public MessagingContext() {
    }

    public MessagingContext(X509KeyManager keyManager, X509TrustManager trustManager) {
        this.keyManager = keyManager;
        this.trustManager = trustManager;
    }

    public MessagingContext(KeyStoreService clientKeyStoreService, PrivateKeyStrategy clientDefaultAliasKeyStrategy, TrustStoreService trustStoreService) {
        this.keyManager = new KeyManagerWrapperWithKeyServiceAndStrategy(clientKeyStoreService, clientDefaultAliasKeyStrategy);
        this.trustManager = new TrustManagerWrapperWithTrustService(trustStoreService);
    }

    public MessagingContext(KeyStoreService clientKeyStoreService, PrivateKeyStrategy clientDefaultAliasKeyStrategy, TrustStrategy trustStrategy) {
        this.keyManager = new KeyManagerWrapperWithKeyServiceAndStrategy(clientKeyStoreService, clientDefaultAliasKeyStrategy);
        this.trustManager = new TrustManagerWrapperWithStrategy(trustStrategy);
    }

    public X509KeyManager getClientKeyManager() throws Exception {
        return this.keyManager;
    }

    public TrustManager getClientTrustManager() throws Exception {
        return this.trustManager;
    }
}

