/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.ssl;

import java.lang.invoke.MethodHandles;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.http.ssl.PrivateKeyDetails;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.cryptography.service.keystore.KeyStoreService;

public class KeyManagerWrapperWithKeyServiceAndStrategy
implements X509KeyManager {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final X509KeyManager keyManager;
    private final PrivateKeyStrategy aliasStrategy;

    public KeyManagerWrapperWithKeyServiceAndStrategy(KeyStoreService keyStoreService, PrivateKeyStrategy aliasStrategy) {
        this.aliasStrategy = aliasStrategy;
        KeyManagerFactory kmf = null;
        try {
            kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(keyStoreService.getUnderlyingKeyStore(), keyStoreService.getPassword().toCharArray());
        }
        catch (Exception e) {
            logger.error("KeyManager could not be initialized");
            throw new RuntimeException("KeyManager could not be initialized", e);
        }
        KeyManager[] kms = kmf.getKeyManagers();
        if (kms != null && aliasStrategy != null) {
            for (int i = 0; i < kms.length; ++i) {
                KeyManager km = kms[i];
                if (!(km instanceof X509KeyManager)) continue;
                this.keyManager = (X509KeyManager)km;
                return;
            }
        }
        this.keyManager = null;
        throw new RuntimeException("X509KeyManager could not be initialized");
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.keyManager.getClientAliases(keyType, issuers);
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        HashMap<String, PrivateKeyDetails> validAliases = new HashMap<String, PrivateKeyDetails>();
        for (String keyType : keyTypes) {
            String[] aliases = this.keyManager.getClientAliases(keyType, issuers);
            if (aliases == null) continue;
            for (String alias : aliases) {
                validAliases.put(alias, new PrivateKeyDetails(keyType, this.keyManager.getCertificateChain(alias)));
            }
        }
        return this.aliasStrategy.chooseAlias(validAliases, socket);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.keyManager.getServerAliases(keyType, issuers);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        HashMap<String, PrivateKeyDetails> validAliases = new HashMap<String, PrivateKeyDetails>();
        String[] aliases = this.keyManager.getServerAliases(keyType, issuers);
        if (aliases != null) {
            for (String alias : aliases) {
                validAliases.put(alias, new PrivateKeyDetails(keyType, this.keyManager.getCertificateChain(alias)));
            }
        }
        return this.aliasStrategy.chooseAlias(validAliases, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.keyManager.getCertificateChain(alias);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.keyManager.getPrivateKey(alias);
    }
}

