/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.ssl;

import java.net.URI;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import won.cryptography.service.CertificateService;
import won.cryptography.ssl.AliasGenerator;

public class AliasFromWebIdGeneratorStrategy
implements AliasGenerator {
    @Override
    public String generateAlias(X509Certificate certificate) throws CertificateException {
        String alias = null;
        try {
            List<URI> webIds = CertificateService.getWebIdFromSubjectAlternativeNames(certificate);
            alias = webIds.get(0).toString();
        }
        catch (Exception e) {
            throw new CertificateException("Alias generation from WebID failed", e);
        }
        return alias;
    }
}

