/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.ssl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import won.cryptography.ssl.AliasGenerator;

public class AliasFromFingerprintGenerator
implements AliasGenerator {
    @Override
    public String generateAlias(X509Certificate certificate) throws CertificateException {
        String fingerprint = null;
        try {
            fingerprint = this.digest(certificate.getPublicKey().getEncoded());
        }
        catch (Exception e) {
            new CertificateException("Alias generation from certificate fingerprint failed", e);
        }
        return fingerprint;
    }

    public String digest(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA3-224");
        byte[] hash = md.digest(data);
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(0xFF & hash[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static void main(String ... args) throws Exception {
        System.out.println("digest:" + new AliasFromFingerprintGenerator().digest("digest".getBytes()));
    }
}

