/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.service.keystore;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.cryptography.service.keystore.AbstractKeyStoreService;

public class FileBasedKeyStoreService
extends AbstractKeyStoreService {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String PROVIDER_BC = "BC";
    private static final String KEY_STORE_TYPE = "UBER";
    private String storePW;
    private File storeFile;
    private KeyStore store;
    private final Ehcache ehcache;
    private final String provider;
    private final String keyStoreType;

    public FileBasedKeyStoreService(String filePath, String storePW) {
        this(new File(filePath), storePW, PROVIDER_BC, KEY_STORE_TYPE);
    }

    public FileBasedKeyStoreService(File storeFile, String storePW) {
        this(storeFile, storePW, PROVIDER_BC, KEY_STORE_TYPE);
    }

    public FileBasedKeyStoreService(File storeFile, String storePW, String provider, String keyStoreType) {
        this.storeFile = storeFile;
        this.storePW = storePW;
        this.provider = provider;
        this.keyStoreType = keyStoreType;
        logger.info("Using key store file {} with key store type {}, provider {}", new Object[]{storeFile, keyStoreType, provider});
        CacheManager manager = CacheManager.getInstance();
        this.ehcache = new Cache("keyCache" + storeFile.hashCode(), 100, false, false, 60L, 60L);
        manager.addCache(this.ehcache);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        Element cachedElement = this.ehcache.get((Serializable)((Object)("KEY++" + alias)));
        if (cachedElement != null) {
            return (PrivateKey)cachedElement.getObjectValue();
        }
        PrivateKey retrieved = null;
        try {
            retrieved = (PrivateKey)this.store.getKey(alias, this.storePW.toCharArray());
        }
        catch (Exception e) {
            logger.warn("Could not retrieve key for " + alias + " from ks " + this.storeFile.getName(), (Throwable)e);
        }
        if (retrieved != null) {
            this.ehcache.put(new Element((Serializable)((Object)("KEY++" + alias)), (Serializable)retrieved));
        }
        return retrieved;
    }

    @Override
    public PublicKey getPublicKey(String alias) {
        Certificate cert = this.getCertificate(alias);
        if (cert == null) {
            logger.warn("No certificate found for alias {}", (Object)alias);
            return null;
        }
        return cert.getPublicKey();
    }

    @Override
    public String getPassword() {
        return this.storePW;
    }

    @Override
    public Certificate getCertificate(String alias) {
        Element cachedElement = this.ehcache.get((Serializable)((Object)("CERT++" + alias)));
        if (cachedElement != null) {
            return (Certificate)cachedElement.getObjectValue();
        }
        Certificate retrieved = null;
        try {
            retrieved = this.store.getCertificate(alias);
        }
        catch (Exception e) {
            logger.warn("No certificate found for alias " + alias, (Throwable)e);
        }
        this.ehcache.put(new Element((Serializable)((Object)("CERT++" + alias)), (Serializable)retrieved));
        return retrieved;
    }

    @Override
    public String getCertificateAlias(Certificate cert) {
        String retrieved = null;
        try {
            retrieved = this.store.getCertificateAlias(cert);
        }
        catch (Exception e) {
            logger.warn("No alias found for certificate", (Throwable)e);
        }
        return retrieved;
    }

    @Override
    public KeyStore getUnderlyingKeyStore() {
        return this.store;
    }

    @Override
    public synchronized void putCertificate(String alias, Certificate certificate, boolean replace) throws IOException {
        this.putEntry(alias, null, null, certificate, replace);
    }

    @Override
    protected synchronized void persistStore() throws Exception {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(this.storeFile);
        }
        catch (IOException e) {
            logger.error("Could not create key store in file " + this.storeFile.getName(), (Throwable)e);
            throw e;
        }
        if (outputStream != null) {
            try {
                this.store.store(outputStream, this.storePW.toCharArray());
            }
            catch (Exception e) {
                logger.error("Could not save key store to file" + this.storeFile.getName(), (Throwable)e);
                throw new IOException(e);
            }
            finally {
                try {
                    outputStream.close();
                }
                catch (Exception e) {
                    logger.error("Error closing stream of file" + this.storeFile.getName(), (Throwable)e);
                    throw e;
                }
            }
        }
    }

    private void loadStoreFromFile() throws Exception {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(this.storeFile);
        }
        catch (FileNotFoundException e) {
            logger.error("Could not load key store from file" + this.storeFile.getName(), (Throwable)e);
            throw e;
        }
        if (inputStream != null) {
            try {
                this.store.load(inputStream, this.storePW.toCharArray());
            }
            catch (Exception e) {
                logger.error("Could not load key store from file " + this.storeFile.getName(), (Throwable)e);
                throw e;
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    logger.error("Error closing stream of file " + this.storeFile.getName(), (Throwable)e);
                    throw e;
                }
            }
        }
    }

    public void init() throws Exception {
        try {
            this.store = this.provider == null ? KeyStore.getInstance(this.keyStoreType) : KeyStore.getInstance(this.keyStoreType, this.provider);
            logger.debug("KEYSTORE: " + this.store);
            if (this.storeFile == null || !this.storeFile.exists() || !this.storeFile.isFile()) {
                this.store.load(null, null);
            } else {
                this.loadStoreFromFile();
            }
        }
        catch (Exception e) {
            logger.error("Error initializing key store " + this.storeFile.getName(), (Throwable)e);
            throw e;
        }
    }
}

