/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.service.keystore;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.cryptography.service.keystore.KeyStoreService;

public abstract class AbstractKeyStoreService
implements KeyStoreService {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String PROVIDER_BC = "BC";
    private static final String KEY_STORE_TYPE = "UBER";

    @Override
    public PrivateKey getPrivateKey(String alias) {
        try {
            return (PrivateKey)this.getUnderlyingKeyStore().getKey(alias, this.getPassword().toCharArray());
        }
        catch (Exception e) {
            logger.warn("Could not retrieve key for " + alias + " from keystore", (Throwable)e);
            return null;
        }
    }

    @Override
    public PublicKey getPublicKey(String alias) {
        Certificate cert = this.getCertificate(alias);
        if (cert == null) {
            logger.warn("No certificate found for alias {}", (Object)alias);
            return null;
        }
        return cert.getPublicKey();
    }

    @Override
    public Certificate getCertificate(String alias) {
        try {
            return this.getUnderlyingKeyStore().getCertificate(alias);
        }
        catch (KeyStoreException e) {
            logger.warn("could not retrieve certificate for alias " + alias, (Throwable)e);
            return null;
        }
    }

    @Override
    public String getCertificateAlias(Certificate cert) {
        String retrieved = null;
        try {
            retrieved = this.getUnderlyingKeyStore().getCertificateAlias(cert);
        }
        catch (Exception e) {
            logger.warn("No alias found for certificate", (Throwable)e);
        }
        return retrieved;
    }

    @Override
    public synchronized void putKey(String alias, PrivateKey key, Certificate[] certificateChain, boolean replace) throws IOException {
        this.putEntry(alias, key, certificateChain, null, replace);
    }

    @Override
    public synchronized void putCertificate(String alias, Certificate certificate, boolean replace) throws IOException {
        this.putEntry(alias, null, null, certificate, replace);
    }

    protected synchronized void putEntry(String alias, PrivateKey key, Certificate[] certificateChain, Certificate certificate, boolean replace) {
        KeyStore store = this.getUnderlyingKeyStore();
        try {
            if (!replace && store.containsAlias(alias)) {
                return;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error checking if key with alias '" + alias + "' is in the keystore", e);
        }
        try {
            if (alias == null) {
                throw new RuntimeException("Could not add keystore entry: provided alias is null");
            }
            if (alias != null && key != null && certificateChain != null) {
                store.setKeyEntry(alias, key, this.getPassword().toCharArray(), certificateChain);
            } else if (alias != null && certificate != null) {
                store.setCertificateEntry(alias, certificate);
            } else {
                throw new RuntimeException("Could not add keystore entry: neither key and cert chain nor certificate is provided");
            }
            this.persistStore();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not add entry for " + alias + " to the key store", e);
        }
    }

    protected abstract void persistStore() throws Exception;

    public boolean containsEntry(String alias) {
        try {
            return this.getUnderlyingKeyStore().containsAlias(alias);
        }
        catch (KeyStoreException e) {
            return false;
        }
    }
}

