/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.service;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.security.KeyStore;
import java.security.cert.Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.cryptography.service.keystore.FileBasedKeyStoreService;

public class TrustStoreService {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private FileBasedKeyStoreService serviceImpl;

    public TrustStoreService(String filePath, String storePW) {
        this.serviceImpl = new FileBasedKeyStoreService(filePath, storePW);
    }

    public TrustStoreService(File storeFile, String storePW) {
        this.serviceImpl = new FileBasedKeyStoreService(storeFile, storePW);
    }

    public void init() throws Exception {
        this.serviceImpl.init();
    }

    public Certificate getCertificate(String alias) {
        logger.debug("Fetching certificate for alias {}", (Object)alias);
        return this.serviceImpl.getCertificate(alias);
    }

    public boolean isCertKnown(Certificate cert) {
        boolean isKnown = this.serviceImpl.getCertificateAlias(cert) != null;
        logger.debug("Presented certificate is known: {}", (Object)isKnown);
        return isKnown;
    }

    public void addCertificate(String alias, Certificate cert, boolean replace) throws IOException {
        logger.debug("adding certificate for alias {}, replace: {}", (Object)alias, (Object)replace);
        this.serviceImpl.putCertificate(alias, cert, replace);
    }

    public KeyStore getUnderlyingKeyStore() {
        return this.serviceImpl.getUnderlyingKeyStore();
    }
}

