/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.service;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.transaction.Transactional;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import won.cryptography.service.RegistrationServer;
import won.cryptography.ssl.AliasFromFingerprintGenerator;
import won.cryptography.ssl.AliasGenerator;
import won.protocol.exception.WonProtocolException;
import won.protocol.service.ApplicationManagementService;

public class RegistrationServerCertificateBased
implements RegistrationServer {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ApplicationManagementService ownerManagementService;
    private TrustStrategy trustStrategy;
    private AliasGenerator aliasGenerator = new AliasFromFingerprintGenerator();

    public RegistrationServerCertificateBased(TrustStrategy trustStrategy) {
        this.trustStrategy = trustStrategy;
    }

    @Override
    @Transactional
    public String registerOwner(Object certificateChainObj) throws WonProtocolException {
        String alias = null;
        X509Certificate[] ownerCertChain = new X509Certificate[]{(X509Certificate)certificateChainObj};
        this.checkTrusted(ownerCertChain);
        try {
            alias = this.aliasGenerator.generateAlias(ownerCertChain[0]);
            this.logger.info("Public key hash to be used as ownerApplicationId: {}", (Object)alias);
            alias = this.ownerManagementService.registerOwnerApplication(alias);
        }
        catch (Exception e) {
            this.logger.warn("could not register owner", (Throwable)e);
            throw new WonProtocolException(e);
        }
        return alias;
    }

    @Override
    public String registerNode(Object certificateChainObj) throws WonProtocolException {
        X509Certificate[] nodeCertChain = new X509Certificate[]{(X509Certificate)certificateChainObj};
        this.checkTrusted(nodeCertChain);
        return null;
    }

    private void checkTrusted(X509Certificate[] ownerCertChain) throws WonProtocolException {
        try {
            if (!this.trustStrategy.isTrusted(ownerCertChain, "CLIENT_CERT")) {
                throw new WonProtocolException("Client cannot be trusted!");
            }
        }
        catch (CertificateException e) {
            new WonProtocolException(e);
        }
    }
}

