/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.service;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import javax.annotation.PostConstruct;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import won.cryptography.service.CryptographyUtils;
import won.cryptography.service.RegistrationClient;
import won.cryptography.service.TrustStoreService;
import won.cryptography.service.keystore.KeyStoreService;

public class RegistrationRestClientHttps
implements RegistrationClient {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String registrationQuery;
    private PrivateKeyStrategy privateKeyStrategy;
    private KeyStoreService keyStoreService;
    private TrustStoreService trustStoreService;
    private TrustStrategy trustStrategy;
    private Integer connectionTimeout;
    private Integer readTimeout;
    private RestTemplate restTemplate;
    private HttpEntity<String> entity;

    @PostConstruct
    public void initialize() {
        try {
            this.restTemplate = CryptographyUtils.createSslRestTemplate(this.keyStoreService.getUnderlyingKeyStore(), this.keyStoreService.getPassword(), this.privateKeyStrategy, this.trustStoreService.getUnderlyingKeyStore(), this.trustStrategy, this.readTimeout, this.connectionTimeout, false);
        }
        catch (Exception e) {
            String msg = "Could not create Rest Template for registration";
            logger.error(msg);
            throw new RuntimeException(msg, e);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.TEXT_PLAIN));
        this.entity = new HttpEntity((Object)"parameters", (MultiValueMap)headers);
    }

    public RegistrationRestClientHttps(KeyStoreService keyStoreService, PrivateKeyStrategy privateKeyStrategy, TrustStoreService trustStoreService, TrustStrategy trustStrategy, String registrationQuery) {
        this.keyStoreService = keyStoreService;
        this.privateKeyStrategy = privateKeyStrategy;
        this.trustStoreService = trustStoreService;
        this.trustStrategy = trustStrategy;
        this.registrationQuery = registrationQuery;
        this.readTimeout = 10000;
        this.connectionTimeout = 10000;
    }

    @Override
    public String register(String remoteNodeUri) throws IOException {
        ResponseEntity result = this.restTemplate.exchange(remoteNodeUri + this.registrationQuery, HttpMethod.POST, this.entity, String.class, new Object[0]);
        logger.info("Registration status: " + result.getStatusCode());
        if (!result.getStatusCode().is2xxSuccessful()) {
            throw new IOException("Registration by remote node " + remoteNodeUri + " failed: " + result.toString());
        }
        return (String)result.getBody();
    }
}

