/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.service;

import java.lang.invoke.MethodHandles;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import org.bouncycastle.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.cryptography.key.KeyInformationExtractor;

public class KeyPairService {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private KeyPairGenerator keyPairGeneratorBrainpoolp384r1 = new KeyPairGeneratorSpi.ECDSA();
    private KeyPairGeneratorSpi keyPairGeneratorSecp384r1 = new KeyPairGeneratorSpi.ECDSA();
    private KeyInformationExtractor keyInformationExtractor;

    public KeyPairService(KeyInformationExtractor keyInformationExtractor) {
        this();
        this.keyInformationExtractor = keyInformationExtractor;
    }

    public KeyPairService() {
        ECGenParameterSpec ecGenSpec;
        try {
            ecGenSpec = new ECGenParameterSpec("brainpoolp384r1");
            this.keyPairGeneratorBrainpoolp384r1.initialize(ecGenSpec, new SecureRandom());
        }
        catch (Exception e) {
            logger.error("Could not initialize bouncycastle key pair generator for ECDSA brainpoolp384r1");
            throw new IllegalArgumentException(e);
        }
        try {
            ecGenSpec = new ECGenParameterSpec("secp384r1");
            this.keyPairGeneratorSecp384r1.initialize((AlgorithmParameterSpec)ecGenSpec, new SecureRandom());
        }
        catch (InvalidAlgorithmParameterException e) {
            logger.error("Could not initialize bouncycastle key pair generator for ECDSA secp384r1");
            throw new IllegalArgumentException(e);
        }
    }

    public KeyPair generateNewKeyPairInSecp384r1() {
        KeyPair pair = this.keyPairGeneratorSecp384r1.generateKeyPair();
        return pair;
    }

    public KeyPair generateNewKeyPairInBrainpoolp384r1() {
        KeyPair pair = this.keyPairGeneratorBrainpoolp384r1.generateKeyPair();
        return pair;
    }
}

