/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.service;

import java.io.Serializable;
import java.security.KeyStore;
import javax.crypto.Cipher;
import javax.net.ssl.SSLContext;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import won.cryptography.ssl.PredefinedAliasPrivateKeyStrategy;

public class CryptographyUtils {
    private static final Ehcache ehcache;

    public static boolean checkForUnlimitedSecurityPolicy() {
        try {
            int size = Cipher.getMaxAllowedKeyLength("RC5");
            System.out.println("max allowed key size: " + size);
            return size < 256;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static SSLContext getSSLContext(KeyStore keyStore, String ksPass, PrivateKeyStrategy keyStrategy, KeyStore trustStore, TrustStrategy trustStrategy, boolean allowCached) throws Exception {
        if (allowCached && keyStrategy instanceof PredefinedAliasPrivateKeyStrategy) {
            return CryptographyUtils.getCachedSslContextForPredefinedAlias(keyStore, ksPass, (PredefinedAliasPrivateKeyStrategy)keyStrategy, trustStore, trustStrategy);
        }
        return CryptographyUtils.createSSLContextBuilder(keyStore, ksPass, keyStrategy, trustStore, trustStrategy).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SSLContext getCachedSslContextForPredefinedAlias(KeyStore keyStore, String ksPass, PredefinedAliasPrivateKeyStrategy keyStrategy, KeyStore trustStore, TrustStrategy trustStrategy) throws Exception {
        String cacheKey = keyStrategy.getAlias();
        Element cacheElement = ehcache.get((Serializable)((Object)cacheKey));
        SSLContext sslContext = null;
        if (cacheElement == null) {
            Ehcache ehcache = CryptographyUtils.ehcache;
            synchronized (ehcache) {
                cacheElement = CryptographyUtils.ehcache.get((Serializable)((Object)cacheKey));
                if (cacheElement == null) {
                    sslContext = CryptographyUtils.createSSLContextBuilder(keyStore, ksPass, keyStrategy, trustStore, trustStrategy).build();
                    cacheElement = new Element((Object)cacheKey, (Object)sslContext);
                    CryptographyUtils.ehcache.put(cacheElement);
                }
            }
        }
        sslContext = (SSLContext)cacheElement.getObjectValue();
        return sslContext;
    }

    private static SSLContextBuilder createSSLContextBuilder(KeyStore keyStore, String ksPass, PrivateKeyStrategy keyStrategy, KeyStore trustStore, TrustStrategy trustStrategy) throws Exception {
        SSLContextBuilder contextBuilder = SSLContexts.custom();
        contextBuilder.loadKeyMaterial(keyStore, ksPass.toCharArray(), keyStrategy);
        contextBuilder.loadTrustMaterial(trustStore, trustStrategy);
        return contextBuilder;
    }

    public static RestTemplate createSslRestTemplate(KeyStore keyStore, String ksPass, PrivateKeyStrategy keyStrategy, KeyStore trustStore, TrustStrategy trustStrategy, Integer readTimeout, Integer connectionTimeout, boolean allowCached) throws Exception {
        SSLContext sslContext = CryptographyUtils.getSSLContext(keyStore, ksPass, keyStrategy, trustStore, trustStrategy, allowCached);
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext);
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        if (readTimeout != null) {
            requestFactory.setReadTimeout(readTimeout.intValue());
        }
        if (connectionTimeout != null) {
            requestFactory.setConnectTimeout(connectionTimeout.intValue());
        }
        requestFactory.setHttpClient((HttpClient)httpClient);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        return restTemplate;
    }

    public static RestTemplate createSslRestTemplate(TrustStrategy trustStrategy, Integer readTimeout, Integer connectionTimeout) throws Exception {
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, trustStrategy).build();
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext);
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        if (readTimeout != null) {
            requestFactory.setReadTimeout(readTimeout.intValue());
        }
        if (connectionTimeout != null) {
            requestFactory.setConnectTimeout(connectionTimeout.intValue());
        }
        requestFactory.setHttpClient((HttpClient)httpClient);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        return restTemplate;
    }

    static {
        CacheManager manager = CacheManager.getInstance();
        ehcache = new Cache("sslContextCache", 100, false, false, 3600L, 600L);
        manager.addCache(ehcache);
    }
}

