/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.service;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import won.cryptography.service.CertificateService;
import won.cryptography.service.KeyPairService;
import won.cryptography.service.TrustStoreService;
import won.cryptography.service.keystore.FileBasedKeyStoreService;
import won.cryptography.service.keystore.KeyStoreService;

public class CryptographyService {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private KeyPairService keyPairService;
    private CertificateService certificateService;
    private KeyStoreService keyStoreService;
    @Autowired(required=false)
    private TrustStoreService trustStoreService;
    private String defaultAlias;
    private String keyToTrustFile;
    private String keyToTrustFilePassword;
    private String keyToTrustAlias = null;
    private String keyToTrustAliasUnder = null;
    private String keyToTrustProvider = null;
    private String keyToTrustKeystoreType = null;

    public CryptographyService(KeyStoreService keyStoreService) {
        this(keyStoreService, null);
    }

    public CryptographyService(KeyStoreService keyStoreService, String defaultAlias) {
        this(keyStoreService, new KeyPairService(), new CertificateService(), defaultAlias);
    }

    public CryptographyService(KeyStoreService keyStoreService, KeyPairService keyPairService, CertificateService certificateService, String defaultAlias) {
        this.keyStoreService = keyStoreService;
        this.keyPairService = keyPairService;
        this.certificateService = certificateService;
        this.defaultAlias = defaultAlias;
    }

    @PostConstruct
    public void init() {
        this.createClientDefaultCertificateIfNotPresent();
    }

    private void createClientDefaultCertificateIfNotPresent() {
        if (this.defaultAlias == null) {
            return;
        }
        logger.debug("checking if the certificate with alias {} is in the keystore", (Object)this.defaultAlias);
        if (this.containsEntry(this.defaultAlias)) {
            logger.info("entry with alias {} found in the keystore", (Object)this.defaultAlias);
        } else {
            logger.info("certificate not found under alias {}, creating new one", (Object)this.defaultAlias);
            try {
                this.createNewKeyPair(this.defaultAlias, null);
                logger.info("certificate created");
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create certificate for " + this.defaultAlias, e);
            }
        }
        if (this.keyToTrustFile == null) {
            logger.info("no additional key configured to be imported into truststore");
            return;
        }
        FileBasedKeyStoreService keyToTrustKeyStoreService = new FileBasedKeyStoreService(new File(this.keyToTrustFile), this.keyToTrustFilePassword, this.keyToTrustProvider, this.keyToTrustKeystoreType);
        try {
            keyToTrustKeyStoreService.init();
        }
        catch (Exception e) {
            logger.info("unable to read key for alias " + this.keyToTrustAlias + " from keystore " + this.keyToTrustFile, (Throwable)e);
        }
        Certificate cert = keyToTrustKeyStoreService.getCertificate(this.keyToTrustAlias);
        if (cert == null) {
            try {
                Optional aliases = Collections.list(keyToTrustKeyStoreService.getUnderlyingKeyStore().aliases()).stream().reduce((x, y) -> x + "," + y);
                logger.info("no key for alias {} found in keystore {}. Available aliases: {}", new Object[]{this.keyToTrustAlias, this.keyToTrustFile, aliases.orElse("(none)")});
            }
            catch (Exception e) {
                logger.info("no key for alias " + this.keyToTrustAlias + " found in keystore " + this.keyToTrustFile + "; caught exception while trying to log available aliases", (Throwable)e);
            }
            return;
        }
        logger.info("certificate with alias {} will be added/overwritten in truststore", (Object)this.keyToTrustAliasUnder);
        try {
            this.trustStoreService.addCertificate(this.keyToTrustAliasUnder, cert, true);
        }
        catch (Exception e) {
            logger.info("could not add certificate for alias " + this.keyToTrustAliasUnder + " to truststore", (Throwable)e);
        }
        logger.info("certificate with alias {} has been added to truststore", (Object)this.keyToTrustAliasUnder);
    }

    public KeyPair createNewKeyPair(BigInteger certNumber, String commonName, String webId) throws IOException {
        String alias = webId;
        if (alias == null) {
            alias = commonName;
        }
        KeyPair newKeyPair = this.keyPairService.generateNewKeyPairInSecp384r1();
        X509Certificate newCertificate = this.certificateService.createSelfSignedCertificate(certNumber, newKeyPair, commonName, webId);
        this.keyStoreService.putKey(alias, newKeyPair.getPrivate(), new Certificate[]{newCertificate}, false);
        return newKeyPair;
    }

    public KeyPair createNewKeyPair(String commonName, String webId) throws IOException {
        BigInteger certNumber = BigInteger.valueOf(1L);
        return this.createNewKeyPair(certNumber, commonName, webId);
    }

    public PrivateKey getPrivateKey(String alias) {
        return this.keyStoreService.getPrivateKey(alias);
    }

    public PrivateKey getDefaultPrivateKey() {
        return this.keyStoreService.getPrivateKey(this.defaultAlias);
    }

    public String getDefaultPrivateKeyAlias() {
        return this.defaultAlias;
    }

    public PublicKey getPublicKey(String alias) {
        return this.keyStoreService.getPublicKey(alias);
    }

    public boolean containsEntry(String alias) {
        try {
            return this.keyStoreService.getUnderlyingKeyStore().containsAlias(alias);
        }
        catch (KeyStoreException e) {
            return false;
        }
    }

    public void setDefaultAlias(String defaultAlias) {
        this.defaultAlias = defaultAlias;
    }

    public void setTrustStoreService(TrustStoreService trustStoreService) {
        this.trustStoreService = trustStoreService;
    }

    public void setKeyToTrustAlias(String keyToTrustAlias) {
        this.keyToTrustAlias = keyToTrustAlias;
    }

    public void setKeyToTrustAliasUnder(String keyToTrustAliasUnder) {
        this.keyToTrustAliasUnder = keyToTrustAliasUnder;
    }

    public void setKeyToTrustFile(String keyToTrustFile) {
        this.keyToTrustFile = keyToTrustFile;
    }

    public void setKeyToTrustFilePassword(String keyToTrustFilePassword) {
        this.keyToTrustFilePassword = keyToTrustFilePassword;
    }

    public void setKeyToTrustKeystoreType(String keyToTrustKeystoreType) {
        this.keyToTrustKeystoreType = keyToTrustKeystoreType;
    }

    public void setKeyToTrustProvider(String keyToTrustProvider) {
        this.keyToTrustProvider = keyToTrustProvider;
    }
}

