/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.service;

import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyPair;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.joda.time.DateTime;

public class CertificateService {
    private static final String PROVIDER_BC = "BC";

    public X509Certificate createSelfSignedCertificate(BigInteger serialNumber, KeyPair key, String commonName, String webId) {
        HashMap<ASN1ObjectIdentifier, String> subjectData = new HashMap<ASN1ObjectIdentifier, String>();
        subjectData.put(BCStyle.CN, commonName);
        subjectData.put(BCStyle.OU, "Web of Needs");
        return this.createSelfSignedCertificate(serialNumber, key, subjectData, webId);
    }

    public X509Certificate createSelfSignedCertificate(BigInteger serialNumber, KeyPair key, Map<ASN1ObjectIdentifier, String> subjectData, String webId) {
        X509Certificate cert = null;
        try {
            X509v3CertificateBuilder certBuilder = this.createBuilderWithBasicInfo(serialNumber, key, subjectData);
            if (webId != null) {
                this.addToCertBuilderWebIdInfo(certBuilder, webId);
            }
            ContentSigner certSigner = this.createContentSigner(key);
            cert = new JcaX509CertificateConverter().setProvider(PROVIDER_BC).getCertificate(certBuilder.build(certSigner));
            cert.checkValidity(new Date());
            cert.verify(cert.getPublicKey());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not create certificate for key pair with algorithm " + key.getPublic().getAlgorithm(), e);
        }
        return cert;
    }

    private void addToCertBuilderWebIdInfo(X509v3CertificateBuilder certBuilder, String webID) throws CertificateException {
        if (webID != null) {
            GeneralName[] genNames = new GeneralName[]{new GeneralName(6, webID)};
            try {
                certBuilder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new GeneralNames(genNames));
            }
            catch (CertIOException e) {
                throw new CertificateException("Could not add webID to the certificate" + webID, e);
            }
        }
    }

    private ContentSigner createContentSigner(KeyPair key) throws Exception {
        String signatureAlgorithm;
        if (key.getPublic().getAlgorithm().contains("ECDSA")) {
            signatureAlgorithm = "SHA256WithECDSA";
        } else if (key.getPublic().getAlgorithm().contains("RSA")) {
            signatureAlgorithm = "SHA256WithRSA";
        } else if (key.getPublic().getAlgorithm().contains("DSA")) {
            signatureAlgorithm = "SHA256WithDSA";
        } else {
            throw new IllegalArgumentException(key.getPublic().getAlgorithm() + " is not supported");
        }
        JcaContentSignerBuilder csBuilder = new JcaContentSignerBuilder(signatureAlgorithm);
        ContentSigner sigGen = csBuilder.setProvider(PROVIDER_BC).build(key.getPrivate());
        return sigGen;
    }

    private X509v3CertificateBuilder createBuilderWithBasicInfo(BigInteger serialNumber, KeyPair key, Map<ASN1ObjectIdentifier, String> subjectData) {
        DateTime today = new DateTime();
        Date notBefore = today.minusDays(1).withTimeAtStartOfDay().toDate();
        Date notAfter = today.plusYears(2).withTimeAtStartOfDay().toDate();
        X500NameBuilder nameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        for (ASN1ObjectIdentifier objectIdentifier : subjectData.keySet()) {
            nameBuilder.addRDN(objectIdentifier, subjectData.get(objectIdentifier));
        }
        X500Name subject = nameBuilder.build();
        SubjectPublicKeyInfo subjPubKeyInfo = new SubjectPublicKeyInfo(ASN1Sequence.getInstance((Object)key.getPublic().getEncoded()));
        X509v3CertificateBuilder certGen = new X509v3CertificateBuilder(subject, serialNumber, notBefore, notAfter, subject, subjPubKeyInfo);
        return certGen;
    }

    public static List<URI> getWebIdFromSubjectAlternativeNames(X509Certificate cert) throws CertificateParsingException {
        ArrayList<URI> webIDs = new ArrayList<URI>();
        Collection<List<?>> alternativeNames = cert.getSubjectAlternativeNames();
        if (alternativeNames != null) {
            for (List<?> alternativeName : alternativeNames) {
                Integer id = (Integer)alternativeName.get(0);
                if (id != 6) continue;
                try {
                    URI webID = new URI((String)alternativeName.get(1));
                    webIDs.add(webID);
                }
                catch (URISyntaxException e) {
                    throw new CertificateParsingException("Could not retrieve webID from SAN", e);
                }
            }
        }
        return webIDs;
    }
}

