/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.keymanagement;

import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.cryptography.keymanagement.AtomUriAsAliasStrategy;
import won.cryptography.keymanagement.KeyPairAliasDerivationStrategy;
import won.cryptography.keymanagement.PredefinedAliasStrategy;

public class KeyPairAliasDerivationStrategyFactory {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String predefinedAlias = null;

    public KeyPairAliasDerivationStrategy create() {
        if (this.predefinedAlias == null || this.predefinedAlias.trim().length() == 0) {
            logger.info("There is no predefined alias specified for the key pairs that will be used for atoms. This causes each atom to be created with a new key pair, which is slow and may not be intended. To set the predefined alias and thus only use one key pair for all atoms, use the property key 'owner.fixedPrivateKeyAlias=your-key-alias'");
            return new AtomUriAsAliasStrategy();
        }
        logger.info("There is a predefined alias specified for the key pair that will be used for atoms. This is fast, but each atom created will have the same public key, which might be a privacy risk and may not be intended. To remove the predefined alias and thus use a new key pair for each atom, set the property key 'owner.fixedPrivateKeyAlias=' (i.e., set it to an emptyv alue )");
        return new PredefinedAliasStrategy(this.predefinedAlias);
    }

    public void setPredefinedAlias(String predefinedAlias) {
        this.predefinedAlias = predefinedAlias;
    }
}

