/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.key;

import java.security.Key;
import java.security.PublicKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import won.cryptography.exception.KeyNotSupportedException;
import won.cryptography.key.KeyInformationExtractor;

public class KeyInformationExtractorBouncyCastle
implements KeyInformationExtractor {
    @Override
    public String getAlgorithm(Key key) {
        return key.getAlgorithm();
    }

    @Override
    public String getCurveID(Key key) throws KeyNotSupportedException {
        if (key instanceof ECKey) {
            ECParameterSpec spec = ((ECKey)((Object)key)).getParams();
            if (spec instanceof ECNamedCurveSpec) {
                return ((ECNamedCurveSpec)spec).getName();
            }
            return null;
        }
        throw new KeyNotSupportedException("Key is not an elliptic curve key!");
    }

    @Override
    public String getQX(PublicKey publicKey) throws KeyNotSupportedException {
        if (publicKey instanceof ECPublicKey) {
            return ((ECPublicKey)publicKey).getW().getAffineX().toString(16);
        }
        throw new KeyNotSupportedException("Key is not an elliptic curve key!");
    }

    @Override
    public String getQY(PublicKey publicKey) throws KeyNotSupportedException {
        if (publicKey instanceof ECPublicKey) {
            return ((ECPublicKey)publicKey).getW().getAffineY().toString(16);
        }
        throw new KeyNotSupportedException("Key is not an elliptic curve key!");
    }
}

