/*
 * Copyright 2012  Research Studios Austria Forschungsges.m.b.H.
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package won.protocol.jms;

import won.cryptography.ssl.MessagingContext;
import won.protocol.exception.CamelConfigurationFailedException;

import java.net.URI;
import java.util.List;

/**
 * User: LEIH-NB
 * Date: 24.02.14
 */
//TODO maybe can extend needconfigurator...
public interface OwnerProtocolCamelConfigurator extends CamelConfigurator {
    String configureCamelEndpointForNodeURI(URI wonNodeURI, URI brokerURI, String ownerProtocolQueueName) throws CamelConfigurationFailedException;

    void addRemoteQueueListeners(List<String> endpoints, URI remoteEndpoint) throws CamelConfigurationFailedException;

    void addRouteForEndpoint(String startingEndpoint, final URI wonNodeURI) throws CamelConfigurationFailedException;

    String getStartingEndpoint(URI wonNodeURI);

    void setStartingEndpoint(URI wonNodeURI, String startingEndpoint);

    void setStartingComponent(String startingComponent);

    String getBrokerComponentName(URI resourceUri);

    void setDefaultNodeURI(String defaultNodeURI);

    void setComponentName(String componentName);

    void addCamelComponentForWonNodeBroker(URI wonNodeURI, String brokerComponentName);

    void setMessagingContext(MessagingContext messagingContext);

}
