/*
 * Decompiled with CFR 0.152.
 */
package at.quelltextlich.jacoco.toolbox;

import at.quelltextlich.jacoco.toolbox.HelpTool;
import at.quelltextlich.jacoco.toolbox.Tool;
import at.quelltextlich.jacoco.toolbox.ToolRegistration;
import at.quelltextlich.jacoco.toolbox.ToolRegistry;
import java.util.Arrays;

public class Toolbox
extends Tool {
    ToolRegistry toolRegistry = new ToolRegistry();

    private <T extends Tool> void runTool(Class<T> toolClass, String[] args, String commandName) {
        try {
            Tool tool = (Tool)toolClass.newInstance();
            tool.run(args);
        }
        catch (InstantiationException e) {
            this.exit("Could not instantiate tool '" + commandName + "'", e);
        }
        catch (IllegalAccessException e) {
            this.exit("Could not instantiate tool '" + commandName + "'", e);
        }
    }

    private void printHelp() {
        this.runTool(HelpTool.class, new String[0], "help");
    }

    @Override
    public void run(String[] args) {
        String commandName;
        ToolRegistration toolRegistration;
        if (args == null || args.length == 0) {
            this.printHelp();
            this.exit("No command given");
        }
        if ((toolRegistration = this.toolRegistry.getToolRegistration(commandName = args[0])) == null) {
            this.printHelp();
            this.exit("Unknown tool '" + commandName + "'");
        }
        String[] strippedArgs = args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{};
        this.runTool(toolRegistration.getToolClass(), strippedArgs, commandName);
    }

    public static void main(String[] args) {
        Toolbox toolbox = new Toolbox();
        toolbox.run(args);
    }
}

