/*
 * Decompiled with CFR 0.152.
 */
package at.quelltextlich.jacoco.toolbox;

import at.quelltextlich.jacoco.toolbox.Environment;
import at.quelltextlich.jacoco.toolbox.SystemEnvironment;
import at.quelltextlich.jacoco.toolbox.VersionTool;
import java.io.PrintStream;
import java.util.Arrays;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionHandlerFilter;

public abstract class Tool {
    private Environment environment;
    protected PrintStream stderr;
    protected PrintStream stdout;
    @Option(name="--help", aliases={"-help", "-h", "-?"}, help=true, usage="print this help screen")
    private boolean help;
    @Option(name="--verbose", usage="Turn on verbose mode")
    protected boolean verbose;

    public Tool() {
        this.setEnvironment(new SystemEnvironment());
    }

    void setEnvironment(Environment environment) {
        this.environment = environment;
        this.stderr = this.environment.getStderr();
        this.stdout = this.environment.getStdout();
    }

    protected void parseArgs(String[] args) {
        CmdLineParser parser = new CmdLineParser(this);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            parser.printUsage(this.stderr);
            this.exit("Failed to parse args", e);
        }
        if (this.help) {
            parser.printUsage(this.stderr);
            this.stderr.println();
            this.stderr.print(parser.printExample(OptionHandlerFilter.REQUIRED));
            this.exit(0);
        }
    }

    protected void exit(int exitCode) {
        this.environment.exit(exitCode);
    }

    protected void exit(String reason) {
        this.exit(reason, null);
    }

    protected void exit(String reason, Exception e) {
        if (reason != null) {
            this.stderr.println(reason);
        }
        if (e != null) {
            e.printStackTrace(this.stderr);
        }
        this.exit(1);
    }

    public void run(String[] args) {
        this.parseArgs(args);
        if (this.verbose && !(this instanceof VersionTool)) {
            VersionTool versionTool = new VersionTool();
            versionTool.setEnvironment(this.environment);
            ((Tool)versionTool).run(new String[0]);
            this.stdout.println("Running " + this.getClass() + " with arguments " + Arrays.asList(args));
        }
    }
}

