/*
 * Decompiled with CFR 0.152.
 */
package at.quelltextlich.jacoco.toolbox;

import at.quelltextlich.jacoco.toolbox.Tool;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.jacoco.core.tools.ExecFileLoader;
import org.kohsuke.args4j.Option;

public abstract class InputTool
extends Tool {
    private final boolean doLoad;
    protected ExecFileLoader loader = new ExecFileLoader();
    protected final List<File> inputs = new LinkedList<File>();

    @Option(name="--input", usage="Adds an input to the toolbox. Multiple inputs can be provided in one string by concatenating them using colons (':'). Empty paths get discarded.")
    void addInput(String inputStr) {
        for (String singleInputStr : inputStr.split(":")) {
            if (singleInputStr.isEmpty()) continue;
            File input = new File(singleInputStr);
            if (!input.exists()) {
                this.exit("The file '" + input + "' does not exist");
            }
            if (!input.canRead()) {
                this.exit("The file '" + input + "' is not readable");
            }
            if (this.inputs.add(input)) continue;
            this.exit("Could not add '" + input + "' to inputs");
        }
    }

    public InputTool() {
        this(true);
    }

    public InputTool(boolean doLoad) {
        this.doLoad = doLoad;
    }

    public void loadInputs() {
        for (File input : this.inputs) {
            try {
                this.loader.load(input);
            }
            catch (IOException e) {
                this.exit("Error loading '" + input + "'", e);
            }
        }
    }

    @Override
    public void run(String[] args) {
        super.run(args);
        if (this.doLoad) {
            this.loadInputs();
        }
    }
}

