/*
 * Decompiled with CFR 0.152.
 */
package at.quelltextlich.jacoco.toolbox;

import at.quelltextlich.jacoco.toolbox.HelpTool;
import at.quelltextlich.jacoco.toolbox.IdentifyVersionTool;
import at.quelltextlich.jacoco.toolbox.MergeTool;
import at.quelltextlich.jacoco.toolbox.ReportCsvTool;
import at.quelltextlich.jacoco.toolbox.ReportHtmlTool;
import at.quelltextlich.jacoco.toolbox.ReportXmlTool;
import at.quelltextlich.jacoco.toolbox.Tool;
import at.quelltextlich.jacoco.toolbox.ToolRegistration;
import at.quelltextlich.jacoco.toolbox.VersionTool;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class ToolRegistry {
    Map<String, ToolRegistration> registeredTools;

    public ToolRegistry() {
        this.registerTools();
    }

    private <T extends Tool> void registerTool(String name, String description, Class<T> cls) {
        this.registerTool(name, description, cls, null);
    }

    private <T extends Tool> void registerTool(String name, String description, Class<T> cls, String[] hiddenNames) {
        ToolRegistration registration = new ToolRegistration(name, description, cls);
        this.registeredTools.put(registration.getCommandName(), registration);
        if (hiddenNames != null) {
            for (String hiddenName : hiddenNames) {
                registration = new ToolRegistration(hiddenName, description, cls, false);
                this.registeredTools.put(registration.getCommandName(), registration);
            }
        }
    }

    private void registerTools() {
        this.registeredTools = new HashMap<String, ToolRegistration>();
        String helpDescription = "prints this help page";
        this.registerTool("help", "prints this help page", HelpTool.class, new String[]{"--help", "-help", "-h", "-?"});
        this.registerTool("identify", "shows format version of exec files", IdentifyVersionTool.class);
        this.registerTool("merge", "merges multiple exec files into a single one", MergeTool.class);
        this.registerTool("report-csv", "writes a CSV report", ReportCsvTool.class);
        this.registerTool("report-xml", "writes an XML report", ReportXmlTool.class);
        this.registerTool("report-html", "writes an HTML report", ReportHtmlTool.class);
        this.registerTool("version", "dump toolbox version", VersionTool.class, new String[]{"--version", "-version"});
    }

    public ToolRegistration getToolRegistration(String command) {
        return this.registeredTools.get(command);
    }

    public Collection<ToolRegistration> getRegistrations() {
        LinkedList<ToolRegistration> ret = new LinkedList<ToolRegistration>(this.registeredTools.values());
        Collections.sort(ret);
        return ret;
    }
}

