/*
 * Decompiled with CFR 0.152.
 */
package at.quelltextlich.jacoco.toolbox;

import at.quelltextlich.jacoco.toolbox.InputTool;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.report.DirectorySourceFileLocator;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.MultiSourceFileLocator;
import org.kohsuke.args4j.Option;

public abstract class ReportTool
extends InputTool {
    private static final int TAB_WIDTH = 2;
    private final List<File> analyzeFors = new LinkedList<File>();
    private final List<File> sources = new LinkedList<File>();
    @Option(name="--output", usage="Place to write the report to.", required=true)
    public File output;
    @Option(name="--title", usage="Title used for reports")
    private String title = "Code Coverage Analysis";
    private final MultiSourceFileLocator locator = new MultiSourceFileLocator(2);
    private IBundleCoverage bundle;

    @Option(name="--analyze-for", usage="Add a file to analyze for. This can be a plain class file, a jar file, or a directory. Multiple paths can be provided in one string by concatenating them using colons (':'). Empty paths get discarded.")
    void addAnalyze(String analyzeFor) {
        for (String singleAnalyzeFor : analyzeFor.split(":")) {
            if (singleAnalyzeFor.isEmpty()) continue;
            File file = new File(singleAnalyzeFor);
            if (!file.exists()) {
                this.exit("The file '" + file + "' does not exist");
            }
            if (this.analyzeFors.add(file)) continue;
            this.exit("Could not add '" + file + "' to analyzes");
        }
    }

    @Option(name="--source", usage="Add a directory to search sources in. Multiple paths can be provided in one string by concatenating them using colons (':'). Empty paths get discarded.")
    void addSource(String source) {
        for (String singleSource : source.split(":")) {
            if (singleSource.isEmpty()) continue;
            File file = new File(singleSource);
            if (!file.exists()) {
                this.exit("The file '" + file + "' does not exist");
            }
            if (!file.isDirectory()) {
                this.exit("The file '" + file + "' is not a directory");
            }
            if (this.sources.add(file)) continue;
            this.exit("Could not add '" + file + "' to sources");
        }
    }

    private void buildBundle() {
        CoverageBuilder builder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(this.loader.getExecutionDataStore(), builder);
        for (File file : this.analyzeFors) {
            try {
                analyzer.analyzeAll(file);
            }
            catch (IOException e) {
                this.exit("Could not analyze for '" + file + "'", e);
            }
        }
        this.bundle = builder.getBundle(this.title);
    }

    private void configureLocator() {
        for (File file : this.sources) {
            this.locator.add(new DirectorySourceFileLocator(file, "utf-8", 2));
        }
    }

    protected void visit(IReportVisitor visitor) throws IOException {
        visitor.visitInfo(this.loader.getSessionInfoStore().getInfos(), this.loader.getExecutionDataStore().getContents());
        visitor.visitBundle(this.bundle, this.locator);
        visitor.visitEnd();
    }

    public abstract void writeReport();

    @Override
    public void run(String[] args) {
        super.run(args);
        this.buildBundle();
        this.configureLocator();
        this.writeReport();
    }
}

