/*
 * Decompiled with CFR 0.152.
 */
package at.quelltextlich.jacoco.toolbox;

import at.quelltextlich.jacoco.toolbox.InputTool;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class IdentifyVersionTool
extends InputTool {
    public IdentifyVersionTool() {
        super(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(String[] args) {
        super.run(args);
        for (File file : this.inputs) {
            char version = '\u0000';
            try {
                DataInputStream stream = new DataInputStream(new FileInputStream(file));
                try {
                    byte chunk1 = stream.readByte();
                    if (chunk1 == 1) {
                        char chunk2 = stream.readChar();
                        if (chunk2 == '\uc0c0') {
                            version = stream.readChar();
                        } else {
                            this.exit("Could not find magic number at beginning of file '" + file + "' (found " + chunk2 + ")");
                        }
                    } else {
                        this.exit("Could not find exec block header at beginning of file '" + file + "'");
                    }
                }
                catch (IOException e) {
                    this.exit("Could not read from file '" + file + "+", e);
                }
                finally {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        this.exit("Could not close stream for '" + file + "'", e);
                    }
                }
            }
            catch (FileNotFoundException e) {
                this.exit("Could not find file '" + file + "'", e);
            }
            this.stdout.println(file + ",0x" + Integer.toHexString(version) + "," + version);
        }
    }
}

