/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.mergedresources.versioning;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.mergedresources.versioning.AbstractClasspathResourceVersionProvider;
import org.wicketstuff.mergedresources.versioning.AbstractResourceVersion;
import org.wicketstuff.mergedresources.versioning.IResourceVersionProvider;
import org.wicketstuff.mergedresources.versioning.SimpleResourceVersion;

public class RevisionVersionProvider
extends AbstractClasspathResourceVersionProvider {
    private static final Logger log = LoggerFactory.getLogger(RevisionVersionProvider.class);

    @Override
    public AbstractResourceVersion getVersion(URL url) throws IResourceVersionProvider.VersionException {
        String line = this.readFirstLine(url);
        Matcher m = Pattern.compile("Revision: ([0-9]+)").matcher(line);
        if (m.find()) {
            int value = Integer.valueOf(m.group(1));
            if (value <= 0) {
                throw new IResourceVersionProvider.VersionException("found invalid resource version: " + value + " in " + url);
            }
            return new SimpleResourceVersion(value);
        }
        throw new IResourceVersionProvider.VersionException("did not find version in " + url);
    }

    protected String readFirstLine(URL url) throws IResourceVersionProvider.VersionException {
        String line;
        BufferedReader r = null;
        try {
            r = new BufferedReader(new InputStreamReader(url.openStream()));
            line = r.readLine();
        }
        catch (IOException e) {
            throw new IResourceVersionProvider.VersionException("failed to read line from url: " + url, e);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException e) {
                log.warn("error while closing reader", (Throwable)e);
            }
        }
        return line;
    }
}

