/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.mergedresources.versioning;

import java.net.URL;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.mergedresources.versioning.AbstractResourceVersion;
import org.wicketstuff.mergedresources.versioning.IResourceVersionProvider;

public abstract class AbstractClasspathResourceVersionProvider
implements IResourceVersionProvider {
    @Override
    public final AbstractResourceVersion getVersion(Class<?> scope, String file) throws IResourceVersionProvider.VersionException {
        URL url = this.toURL(scope, file);
        if (url == null) {
            throw new IResourceVersionProvider.VersionException(scope, file, "can't find file " + file + " for scope + " + scope);
        }
        return this.getVersion(url);
    }

    protected abstract AbstractResourceVersion getVersion(URL var1) throws IResourceVersionProvider.VersionException;

    protected URL toURL(Class<?> scope, String file) {
        String path = this.getResourcePath(scope, file);
        URL url = scope.getClassLoader().getResource(path);
        if (url == null) {
            url = Thread.currentThread().getContextClassLoader().getResource(path);
        }
        return url;
    }

    protected String getResourcePath(Class<?> scope, String fileName) {
        String file = Strings.beforeLast((String)scope.getName(), (char)'.').replace('.', '/') + "/" + fileName;
        return file;
    }
}

