/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.mergedresources.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.behavior.AbstractHeaderContributor;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.util.string.Strings;

public class MergedHeaderContributor
extends AbstractHeaderContributor {
    private static final long serialVersionUID = 1L;
    public IHeaderContributor _contributor;
    private final ArrayList<ResourceReference> _refs;
    private final String _cssMediaType;

    public MergedHeaderContributor(List<ResourceReference> refs) {
        this(refs, null);
    }

    public MergedHeaderContributor(List<ResourceReference> refs, String cssMediaType) {
        this._refs = new ArrayList<ResourceReference>(refs);
        this._cssMediaType = cssMediaType;
        this._contributor = new IHeaderContributor(){
            private static final long serialVersionUID = 1L;

            public void renderHead(IHeaderResponse response) {
                for (ResourceReference ref : MergedHeaderContributor.this._refs) {
                    String name = ref.getName();
                    if (name == null) continue;
                    if (name.endsWith(".js")) {
                        response.renderJavascriptReference(ref);
                        continue;
                    }
                    if (!name.endsWith(".css")) continue;
                    if (Strings.isEmpty((CharSequence)MergedHeaderContributor.this._cssMediaType)) {
                        response.renderCSSReference(ref);
                        continue;
                    }
                    response.renderCSSReference(ref, MergedHeaderContributor.this._cssMediaType);
                }
            }
        };
    }

    public IHeaderContributor[] getHeaderContributors() {
        return new IHeaderContributor[]{this._contributor};
    }
}

