/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.mergedresources.annotations;

import java.util.HashMap;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.application.IComponentInstantiationListener;
import org.apache.wicket.behavior.IBehavior;
import org.wicketstuff.mergedresources.annotations.CssContribution;
import org.wicketstuff.mergedresources.annotations.HeaderContribution;
import org.wicketstuff.mergedresources.annotations.JsContribution;

public class ContributionInjector
implements IComponentInstantiationListener {
    private final HashMap<Class<? extends Component>, HeaderContribution> _contributions = new HashMap();

    public void onInstantiation(Component component) {
        if (this.eligible(component)) {
            this.asMarkupContainer(component).add(new IBehavior[]{this.getHeaderContribution(component.getClass())});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HeaderContribution getHeaderContribution(Class<? extends Component> cls) {
        HeaderContribution hc = this._contributions.get(cls);
        if (hc == null) {
            HashMap<Class<? extends Component>, HeaderContribution> hashMap = this._contributions;
            synchronized (hashMap) {
                hc = new HeaderContribution(cls);
                this._contributions.put(cls, hc);
            }
        }
        return hc;
    }

    private MarkupContainer asMarkupContainer(Component component) {
        return (MarkupContainer)component;
    }

    private boolean hasResourceAnnotation(Component component) {
        return component.getClass().getAnnotation(JsContribution.class) != null || component.getClass().getAnnotation(CssContribution.class) != null;
    }

    private boolean eligible(Component component) {
        return MarkupContainer.class.isAssignableFrom(component.getClass()) && this.hasResourceAnnotation(component);
    }
}

