/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.mergedresources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Resource;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.WicketAjaxReference;
import org.apache.wicket.application.IComponentInstantiationListener;
import org.apache.wicket.behavior.AbstractHeaderContributor;
import org.apache.wicket.markup.html.WicketEventReference;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.target.coding.IRequestTargetUrlCodingStrategy;
import org.apache.wicket.request.target.coding.SharedResourceRequestTargetUrlCodingStrategy;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.mergedresources.ResourceSpec;
import org.wicketstuff.mergedresources.annotations.ContributionInjector;
import org.wicketstuff.mergedresources.annotations.ContributionScanner;
import org.wicketstuff.mergedresources.preprocess.IResourcePreProcessor;
import org.wicketstuff.mergedresources.resources.CachedCompressedCssResourceReference;
import org.wicketstuff.mergedresources.resources.CachedCompressedJsResourceReference;
import org.wicketstuff.mergedresources.resources.CachedCompressedResourceReference;
import org.wicketstuff.mergedresources.resources.CachedResourceReference;
import org.wicketstuff.mergedresources.resources.CompressedMergedCssResourceReference;
import org.wicketstuff.mergedresources.resources.CompressedMergedJsResourceReference;
import org.wicketstuff.mergedresources.resources.CompressedMergedResourceReference;
import org.wicketstuff.mergedresources.resources.ICssCompressor;
import org.wicketstuff.mergedresources.resources.MergedResourceReference;
import org.wicketstuff.mergedresources.util.MergedHeaderContributor;
import org.wicketstuff.mergedresources.util.MergedResourceRequestTargetUrlCodingStrategy;
import org.wicketstuff.mergedresources.util.Pair;
import org.wicketstuff.mergedresources.util.RedirectStrategy;
import org.wicketstuff.mergedresources.versioning.AbstractResourceVersion;
import org.wicketstuff.mergedresources.versioning.IResourceVersionProvider;
import org.wicketstuff.mergedresources.versioning.SimpleResourceVersion;
import org.wicketstuff.mergedresources.versioning.WicketVersionProvider;

public class ResourceMount
implements Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceMount.class);
    private static final MetaDataKey<Boolean> ANNOTATIONS_ENABLED_KEY = new MetaDataKey<Boolean>(){
        private static final long serialVersionUID = 1L;
    };
    public static final int DEFAULT_CACHE_DURATION = (int)Duration.hours((int)1).seconds();
    public static final int DEFAULT_AGGRESSIVE_CACHE_DURATION;
    @Deprecated
    public static final int DEFAULT_AGGRESIVE_CACHE_DURATION;
    public static final Set<String> DEFAULT_COMPRESS_SUFFIXES;
    public static final Set<String> DEFAULT_MERGE_SUFFIXES;
    public static final MetaDataKey<ICssCompressor> CSS_COMPRESSOR_KEY;
    private Integer _cacheDuration = null;
    private String _path = null;
    private AbstractResourceVersion _version = null;
    private AbstractResourceVersion _minVersion = null;
    private boolean _requireVersion = true;
    private IResourceVersionProvider _resourceVersionProvider = null;
    private Boolean _compressed = null;
    private List<ResourceSpec> _resourceSpecs = new ArrayList<ResourceSpec>();
    private Set<String> _compressedSuffixes = new HashSet<String>(DEFAULT_COMPRESS_SUFFIXES);
    private Set<String> _mergedSuffixes = new HashSet<String>(DEFAULT_MERGE_SUFFIXES);
    private Locale _locale;
    private String _style;
    private Boolean _minifyJs;
    private Boolean _minifyCss;
    private boolean _mountRedirect = true;
    private Class<?> _mountScope;
    private Boolean _merge;
    private IResourcePreProcessor _preProcessor;
    private SuffixMismatchStrategy _suffixMismatchStrategy = SuffixMismatchStrategy.EXCEPTION;

    public static void mountWicketResources(String mountPrefix, WebApplication application) {
        ResourceMount.mountWicketResources(mountPrefix, application, new ResourceMount().setDefaultAggressiveCacheDuration());
    }

    public static void mountWicketResources(String mountPrefix, WebApplication application, ResourceMount mount) {
        mount = mount.clone().setResourceVersionProvider(new WicketVersionProvider((Application)application)).setDefaultAggressiveCacheDuration();
        if (!mountPrefix.endsWith("/")) {
            mountPrefix = mountPrefix + "/";
        }
        for (ResourceReference ref : new ResourceReference[]{WicketAjaxReference.INSTANCE, WicketEventReference.INSTANCE}) {
            String path = mountPrefix + ref.getName();
            mount.clone().setPath(path).addResourceSpec(ref).mount(application);
        }
    }

    public static void mountWicketResourcesMerged(String mountPrefix, WebApplication application) {
        ResourceMount.mountWicketResourcesMerged(mountPrefix, application, new ResourceMount().setDefaultAggressiveCacheDuration());
    }

    public static void mountWicketResourcesMerged(String mountPrefix, WebApplication application, ResourceMount mount) {
        if (!mountPrefix.endsWith("/")) {
            mountPrefix = mountPrefix + "/";
        }
        mount = mount.clone().setResourceVersionProvider(new WicketVersionProvider((Application)application)).setPath(mountPrefix + "wicket.js").setMerged(true);
        for (ResourceReference ref : new ResourceReference[]{WicketEventReference.INSTANCE, WicketAjaxReference.INSTANCE}) {
            mount.addResourceSpec(ref);
        }
        mount.mount(application);
    }

    public static void enableAnnotations(WebApplication application) {
        Boolean enabled = (Boolean)application.getMetaData(ANNOTATIONS_ENABLED_KEY);
        if (!Boolean.TRUE.equals(enabled)) {
            try {
                Class.forName("org.wicketstuff.config.MatchingResources");
                Class.forName("org.springframework.core.io.support.PathMatchingResourcePatternResolver");
            }
            catch (ClassNotFoundException e) {
                throw new WicketRuntimeException("in order to enable wicketstuff-merged-resources' annotation support, wicketstuff-annotations and spring-core must be on the path (see http://wicketstuff.org/confluence/display/STUFFWIKI/wicketstuff-annotation for details)");
            }
            application.addComponentInstantiationListener((IComponentInstantiationListener)new ContributionInjector());
            application.setMetaData(ANNOTATIONS_ENABLED_KEY, (Object)Boolean.TRUE);
        }
    }

    public static void mountAnnotatedPackageResources(String mountPrefix, Class<?> scope, WebApplication application, ResourceMount mount) {
        ResourceMount.mountAnnotatedPackageResources(mountPrefix, scope.getPackage(), application, mount);
    }

    public static void mountAnnotatedPackageResources(String mountPrefix, Package pkg, WebApplication application, ResourceMount mount) {
        ResourceMount.mountAnnotatedPackageResources(mountPrefix, pkg.getName(), application, mount);
    }

    public static void mountAnnotatedPackageResources(String mountPrefix, String packageName, WebApplication application, ResourceMount mount) {
        ResourceMount.enableAnnotations(application);
        if (Strings.isEmpty((CharSequence)mountPrefix)) {
            mountPrefix = "/";
        }
        if (!mountPrefix.endsWith("/")) {
            mountPrefix = mountPrefix + "/";
        }
        if (!mountPrefix.startsWith("/")) {
            mountPrefix = "/" + mountPrefix;
        }
        for (Map.Entry<String, SortedSet<ContributionScanner.WeightedResourceSpec>> e : new ContributionScanner(packageName).getContributions().entrySet()) {
            String path = e.getKey();
            if (Strings.isEmpty((CharSequence)path)) {
                throw new WicketRuntimeException("path must not be empty");
            }
            SortedSet<ContributionScanner.WeightedResourceSpec> specs = e.getValue();
            if (specs.size() <= 0) continue;
            ResourceMount m = mount.clone();
            m.setRequireVersion(false);
            m.setPath(path.startsWith("/") ? path : mountPrefix + path);
            m.addResourceSpecs(specs);
            m.mount(application);
        }
    }

    public static String getSuffix(String path) {
        if (path == null) {
            return null;
        }
        int slash = path.lastIndexOf(47);
        if (slash >= 0) {
            path = path.substring(slash + 1);
        }
        while (path.startsWith(".")) {
            path = path.substring(1);
        }
        int dot = path.lastIndexOf(46);
        if (dot >= 0 && dot < path.length() - 1) {
            return path.substring(dot + 1);
        }
        return null;
    }

    public static void setCssCompressor(Application application, ICssCompressor compressor) {
        application.setMetaData(CSS_COMPRESSOR_KEY, (Object)compressor);
    }

    public static ICssCompressor getCssCompressor(Application application) {
        return (ICssCompressor)application.getMetaData(CSS_COMPRESSOR_KEY);
    }

    public ResourceMount() {
        this(false);
    }

    public ResourceMount(boolean development) {
        if (development) {
            this.setCacheDuration(0);
            this.setMerged(false);
            this.setMinifyCss(false);
            this.setMinifyJs(false);
        }
    }

    public ResourceMount setCompressed(boolean compressed) {
        this._compressed = compressed;
        return this;
    }

    public ResourceMount autodetectCompression() {
        this._compressed = null;
        return this;
    }

    public ResourceMount setMerged(boolean merge) {
        this._merge = merge;
        return this;
    }

    public ResourceMount autodetectMerging() {
        this._merge = null;
        return this;
    }

    public ResourceMount setVersion(AbstractResourceVersion version) {
        this._version = version;
        return this;
    }

    public ResourceMount setNoVersion() {
        return this.setVersion(AbstractResourceVersion.NO_VERSION);
    }

    public ResourceMount autodetectVersion() {
        return this.setVersion(null);
    }

    public ResourceMount setMinVersion(AbstractResourceVersion minVersion) {
        this._minVersion = minVersion;
        return this;
    }

    public ResourceMount setMinVersion(int minVersionValue) {
        return this.setMinVersion(new SimpleResourceVersion(minVersionValue));
    }

    public ResourceMount unsetMinVersion() {
        return this.setMinVersion(null);
    }

    public ResourceMount setRequireVersion(boolean requireVersion) {
        this._requireVersion = requireVersion;
        return this;
    }

    public ResourceMount setPath(String path) {
        if (path != null) {
            if ("".equals(path = path.trim()) || "/".equals(path)) {
                throw new IllegalArgumentException("path must not be empty or '/', was " + path);
            }
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
        }
        this._path = path;
        return this;
    }

    public ResourceMount setPath(String prefix, ResourceReference ref) {
        if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        return this.setPath(prefix + ref.getName());
    }

    public ResourceMount setPath(String prefix, ResourceReference ref, String suffix) {
        return this.setPath(prefix, ref.getName(), suffix);
    }

    public ResourceMount setPath(String prefix, String name, String suffix) {
        if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        if (Strings.isEmpty((CharSequence)suffix)) {
            suffix = "";
        } else if (!suffix.startsWith(".") && !suffix.startsWith("-")) {
            suffix = "." + suffix;
        }
        return this.setPath(prefix + name + suffix);
    }

    public ResourceMount setMountRedirect(boolean mountRedirect) {
        this._mountRedirect = mountRedirect;
        return this;
    }

    public ResourceMount setLocale(Locale locale) {
        this._locale = locale;
        return this;
    }

    public ResourceMount autodetectLocale() {
        return this.setLocale(null);
    }

    public ResourceMount setStyle(String style) {
        this._style = style;
        return this;
    }

    public ResourceMount autodetectStyle() {
        return this.setStyle(null);
    }

    public ResourceMount setCacheDuration(int cacheDuration) {
        if (cacheDuration < 0) {
            throw new IllegalArgumentException("cacheDuration must not be < 0, was " + cacheDuration);
        }
        this._cacheDuration = cacheDuration;
        return this;
    }

    public ResourceMount setDefaultCacheDuration() {
        return this.setCacheDuration(DEFAULT_CACHE_DURATION);
    }

    public ResourceMount setDefaultAggressiveCacheDuration() {
        return this.setCacheDuration(DEFAULT_AGGRESSIVE_CACHE_DURATION);
    }

    @Deprecated
    public ResourceMount setDefaultAggresiveCacheDuration() {
        return this.setCacheDuration(DEFAULT_AGGRESSIVE_CACHE_DURATION);
    }

    public ResourceMount autodetectCacheDuration() {
        this._cacheDuration = null;
        return this;
    }

    public ResourceMount setResourceVersionProvider(IResourceVersionProvider resourceVersionProvider) {
        this._resourceVersionProvider = resourceVersionProvider;
        return this;
    }

    public ResourceMount setMinifyJs(Boolean minifyJs) {
        this._minifyJs = minifyJs;
        return this;
    }

    public ResourceMount autodetectMinifyJs() {
        this._minifyJs = null;
        return this;
    }

    public ResourceMount setMinifyCss(Boolean minifyCss) {
        this._minifyCss = minifyCss;
        return this;
    }

    public ResourceMount autodetectMinifyCss() {
        this._minifyCss = null;
        return this;
    }

    public ResourceMount setMountScope(Class<?> mountScope) {
        this._mountScope = mountScope;
        return this;
    }

    public ResourceMount autodetectMountScope() {
        return this.setMountScope(null);
    }

    public IResourcePreProcessor getPreProcessor() {
        return this._preProcessor;
    }

    public ResourceMount setPreProcessor(IResourcePreProcessor preProcessor) {
        this._preProcessor = preProcessor;
        return this;
    }

    public SuffixMismatchStrategy getSuffixMismatchStrategy() {
        return this._suffixMismatchStrategy;
    }

    public ResourceMount setSuffixMismatchStrategy(SuffixMismatchStrategy suffixMismatchStrategy) {
        if (suffixMismatchStrategy == null) {
            throw new NullPointerException("suffixMismatchStrategy");
        }
        this._suffixMismatchStrategy = suffixMismatchStrategy;
        return this;
    }

    public ResourceMount addResourceSpec(ResourceSpec resourceSpec) {
        if (this._resourceSpecs.contains(resourceSpec)) {
            throw new IllegalArgumentException("aleady added: " + resourceSpec);
        }
        this._resourceSpecs.add(resourceSpec);
        return this;
    }

    public ResourceMount addResourceSpec(Class<?> scope, String name) {
        return this.addResourceSpec(new ResourceSpec(scope, name));
    }

    public ResourceMount addResourceSpecs(Class<?> scope, String ... names) {
        for (String name : names) {
            this.addResourceSpec(new ResourceSpec(scope, name));
        }
        return this;
    }

    public ResourceMount addResourceSpec(Class<?> scope, String name, Locale locale, String style, Integer cacheDuration) {
        return this.addResourceSpec(new ResourceSpec(scope, name, locale, style, cacheDuration));
    }

    public ResourceMount addResourceSpecs(ResourceSpec ... resourceSpecs) {
        return this.addResourceSpecs(Arrays.asList(resourceSpecs));
    }

    public ResourceMount addResourceSpecs(Iterable<? extends ResourceSpec> resourceSpecs) {
        for (ResourceSpec resourceSpec : resourceSpecs) {
            this.addResourceSpec(resourceSpec);
        }
        return this;
    }

    public ResourceMount addResourceSpecMatchingSuffix(Class<?> scope, String suffix) {
        if (!suffix.startsWith(".") && !suffix.startsWith("-")) {
            suffix = "." + suffix;
        }
        return this.addResourceSpec(new ResourceSpec(scope, scope.getSimpleName() + suffix));
    }

    public ResourceMount addResourceSpecsMatchingSuffixes(Class<?> scope, String ... suffixes) {
        return this.addResourceSpecsMatchingSuffix(scope, Arrays.asList(suffixes));
    }

    public ResourceMount addResourceSpecsMatchingSuffix(Class<?> scope, Iterable<String> suffixes) {
        for (String suffix : suffixes) {
            this.addResourceSpecMatchingSuffix(scope, suffix);
        }
        return this;
    }

    public ResourceMount addResourceSpecsMatchingSuffix(Class<?> ... scopes) {
        if (this._path == null) {
            throw new IllegalStateException("unversionPath must be set for this method to work");
        }
        String suffix = ResourceMount.getSuffix(this._path);
        if (Strings.isEmpty((CharSequence)suffix) || suffix.contains("/")) {
            throw new IllegalStateException("unversionPath does not have a valid suffix (i.e. does not contain a '.' followed by characterers and no '/')");
        }
        for (Class<?> scope : scopes) {
            this.addResourceSpecMatchingSuffix(scope, suffix);
        }
        return this;
    }

    public ResourceMount addResourceSpec(ResourceReference ref) {
        return this.addResourceSpec(new ResourceSpec(ref));
    }

    public ResourceMount addResourceSpecs(ResourceReference ... refs) {
        for (ResourceReference ref : refs) {
            this.addResourceSpec(ref);
        }
        return this;
    }

    public ResourceMount mount(WebApplication application) {
        this.build(application);
        return this;
    }

    public AbstractHeaderContributor build(WebApplication application) {
        return this.build(application, null);
    }

    public AbstractHeaderContributor build(WebApplication application, String cssMediaType) {
        if (this._resourceSpecs.size() == 0) {
            return null;
        }
        try {
            ArrayList<Pair<Object, ResourceSpec[]>> specsList;
            boolean merge = this.doMerge();
            if (merge) {
                specsList = new ArrayList<Pair<Object, ResourceSpec[]>>(1);
                specsList.add(new Pair<Object, ResourceSpec[]>(null, this.getResourceSpecs()));
            } else {
                specsList = new ArrayList(this._resourceSpecs.size());
                for (ResourceSpec spec : this._resourceSpecs) {
                    specsList.add(new Pair<String, ResourceSpec[]>(this._resourceSpecs.size() > 1 ? spec.getFile() : null, new ResourceSpec[]{spec}));
                }
            }
            ArrayList<ResourceReference> refs = new ArrayList<ResourceReference>(specsList.size());
            for (Pair pair : specsList) {
                ResourceSpec[] specs = (ResourceSpec[])pair.getSecond();
                String path = this.getPath((String)pair.getFirst(), specs);
                String unversionedPath = this.getPath((String)pair.getFirst(), null);
                this.checkSuffixes(unversionedPath, Arrays.asList(specs));
                boolean versioned = !unversionedPath.equals(path);
                String name = specs.length == 1 ? specs[0].getFile() : unversionedPath;
                ResourceReference ref = this.newResourceReference(this.getScope(specs), name, this.getLocale(specs), this.getStyle(specs), this.getCacheDuration(specs, versioned), specs, this._preProcessor);
                refs.add(ref);
                ref.bind((Application)application);
                application.mount(this.newStrategy(path, ref, merge));
                if (this._mountRedirect && versioned) {
                    application.mount(this.newRedirectStrategy(unversionedPath, path));
                }
                this.initResource(ref);
            }
            return this.newHeaderContributor(refs, cssMediaType);
        }
        catch (IResourceVersionProvider.VersionException e) {
            throw new WicketRuntimeException("failed to mount resource ('" + this._path + "')", (Throwable)e);
        }
        catch (AbstractResourceVersion.IncompatibleVersionsException e) {
            throw new WicketRuntimeException("failed to mount resource ('" + this._path + "')", (Throwable)e);
        }
        catch (ResourceStreamNotFoundException e) {
            throw new WicketRuntimeException("failed to mount resource ('" + this._path + "')", (Throwable)e);
        }
    }

    protected AbstractHeaderContributor newHeaderContributor(List<ResourceReference> refs, String cssMediaType) {
        return new MergedHeaderContributor(refs, cssMediaType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initResource(ResourceReference ref) throws ResourceStreamNotFoundException {
        boolean gzip = Application.get().getResourceSettings().getDisableGZipCompression();
        try {
            Application.get().getResourceSettings().setDisableGZipCompression(true);
            ref.getResource().getResourceStream().getInputStream();
        }
        finally {
            Application.get().getResourceSettings().setDisableGZipCompression(gzip);
        }
    }

    protected IRequestTargetUrlCodingStrategy newStrategy(String mountPath, final ResourceReference ref, boolean merge) {
        if (merge) {
            ArrayList<String> mergedKeys = new ArrayList<String>(this._resourceSpecs.size());
            for (ResourceSpec spec : this._resourceSpecs) {
                mergedKeys.add(new ResourceReference(spec.getScope(), spec.getFile()){
                    private static final long serialVersionUID = 1L;

                    protected Resource newResource() {
                        Resource r = ref.getResource();
                        if (r == null) {
                            throw new WicketRuntimeException("ResourceReference wasn't bound to application yet");
                        }
                        return r;
                    }
                }.getSharedResourceKey());
            }
            return new MergedResourceRequestTargetUrlCodingStrategy(mountPath, ref.getSharedResourceKey(), mergedKeys);
        }
        return new SharedResourceRequestTargetUrlCodingStrategy(mountPath, ref.getSharedResourceKey());
    }

    protected IRequestTargetUrlCodingStrategy newRedirectStrategy(String mountPath, String redirectPath) {
        return new RedirectStrategy(mountPath, redirectPath);
    }

    public final String getPath() throws IResourceVersionProvider.VersionException, AbstractResourceVersion.IncompatibleVersionsException {
        return this.getPath(null, null);
    }

    public final String getPath(String appendName) throws IResourceVersionProvider.VersionException, AbstractResourceVersion.IncompatibleVersionsException {
        return this.getPath(appendName, null);
    }

    public String getPath(String appendName, ResourceSpec[] specs) throws IResourceVersionProvider.VersionException, AbstractResourceVersion.IncompatibleVersionsException, IllegalStateException {
        AbstractResourceVersion version;
        if (this._path == null) {
            throw new IllegalStateException("path must be set");
        }
        String path = this._path;
        if (appendName != null) {
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            path = path + appendName;
        }
        if (specs != null && specs.length > 0 && (version = this.getVersion(specs)) != null && version.isValid()) {
            return this.buildVersionedPath(path, version);
        }
        return path;
    }

    protected String buildVersionedPath(String path, AbstractResourceVersion version) {
        if (!version.isValid()) {
            return path;
        }
        int idx = path.lastIndexOf(46);
        if (idx > 0) {
            return path.substring(0, idx) + "-" + version.getVersion() + path.substring(idx);
        }
        return path + "-" + version.getVersion();
    }

    protected AbstractResourceVersion getVersion(ResourceSpec[] specs) throws IResourceVersionProvider.VersionException, AbstractResourceVersion.IncompatibleVersionsException {
        if (this._version != null) {
            return this._version;
        }
        if (this._resourceVersionProvider != null) {
            AbstractResourceVersion max = this._minVersion;
            for (ResourceSpec spec : specs) {
                try {
                    AbstractResourceVersion version = this._resourceVersionProvider.getVersion(spec.getScope(), spec.getFile());
                    if (max != null && version.compareTo(max) <= 0) continue;
                    max = version;
                }
                catch (IResourceVersionProvider.VersionException e) {
                    if (!this._requireVersion) continue;
                    throw e;
                }
            }
            return max;
        }
        return null;
    }

    protected Class<?> getScope(ResourceSpec[] specs) {
        if (this._mountScope != null) {
            return this._mountScope;
        }
        Class<?> scope = null;
        for (ResourceSpec resourceSpec : specs) {
            if (scope == null) {
                scope = resourceSpec.getScope();
                continue;
            }
            if (scope.equals(resourceSpec.getScope())) continue;
            scope = null;
            break;
        }
        if (scope != null) {
            return scope;
        }
        return ResourceMount.class;
    }

    protected ResourceReference newResourceReference(Class<?> scope, String name, Locale locale, String style, int cacheDuration, ResourceSpec[] resourceSpecs, IResourcePreProcessor preProcessor) {
        ResourceReference ref;
        if (resourceSpecs.length > 1) {
            ref = this.doCompress(name) ? (this.doMinifyCss(name) ? new CompressedMergedCssResourceReference(name, locale, style, resourceSpecs, cacheDuration, preProcessor) : (this.doMinifyJs(name) ? new CompressedMergedJsResourceReference(name, locale, style, resourceSpecs, cacheDuration, preProcessor) : new CompressedMergedResourceReference(name, locale, style, resourceSpecs, cacheDuration, preProcessor))) : new MergedResourceReference(name, locale, style, resourceSpecs, cacheDuration, preProcessor);
        } else if (resourceSpecs.length == 1) {
            ref = this.doCompress(name) ? (this.doMinifyCss(name) ? new CachedCompressedCssResourceReference(scope, name, locale, style, cacheDuration, preProcessor) : (this.doMinifyJs(name) ? new CachedCompressedJsResourceReference(scope, name, locale, style, cacheDuration, preProcessor) : new CachedCompressedResourceReference(scope, name, locale, style, cacheDuration, preProcessor))) : new CachedResourceReference(scope, name, locale, style, cacheDuration, preProcessor);
        } else {
            throw new IllegalArgumentException("can't create ResourceReference without ResourceSpec");
        }
        return ref;
    }

    protected Locale getLocale(ResourceSpec[] specs) {
        if (this._locale != null) {
            return this._locale;
        }
        Locale locale = null;
        for (ResourceSpec spec : specs) {
            if (locale != null) {
                Locale newLocale = locale;
                if (spec.getLocale() != null) {
                    if (spec.getLocale().getLanguage() != null) {
                        newLocale = locale;
                        if (locale.getLanguage() != null && !spec.getLocale().getLanguage().equals(locale.getLanguage())) {
                            throw new IllegalStateException("languages aren't compatible: '" + locale + "' and '" + spec.getLocale() + "'");
                        }
                    }
                    if (spec.getLocale().getCountry() != null) {
                        if (locale.getCountry() != null && !spec.getLocale().getCountry().equals(locale.getCountry())) {
                            throw new IllegalStateException("countries aren't compatible: '" + locale + "' and '" + spec.getLocale() + "'");
                        }
                    } else if (locale.getCountry() != null) {
                        newLocale = locale;
                    }
                }
                locale = newLocale;
                continue;
            }
            locale = spec.getLocale();
        }
        return locale;
    }

    protected String getStyle(ResourceSpec[] specs) {
        if (this._style != null) {
            return this._style;
        }
        String style = null;
        for (ResourceSpec spec : specs) {
            if (style != null) {
                if (spec.getStyle() == null || spec.getStyle().equals(style)) continue;
                throw new IllegalStateException("styles aren't compatible: '" + style + "' and '" + spec.getStyle() + "'");
            }
            style = spec.getStyle();
        }
        return style;
    }

    protected int getCacheDuration(ResourceSpec[] specs, boolean versioned) {
        if (this._cacheDuration != null) {
            return this._cacheDuration;
        }
        if (versioned) {
            return DEFAULT_AGGRESSIVE_CACHE_DURATION;
        }
        Integer cacheDuration = null;
        for (ResourceSpec spec : specs) {
            if (cacheDuration == null) {
                cacheDuration = spec.getCacheDuration();
                continue;
            }
            if (spec.getCacheDuration() == null || spec.getCacheDuration() >= cacheDuration) continue;
            cacheDuration = spec.getCacheDuration();
        }
        if (cacheDuration == null) {
            cacheDuration = DEFAULT_CACHE_DURATION;
        }
        return cacheDuration;
    }

    protected ResourceSpec[] getResourceSpecs() {
        return this._resourceSpecs.toArray(new ResourceSpec[this._resourceSpecs.size()]);
    }

    protected boolean doCompress(String file) {
        return this._compressed == null ? this._compressedSuffixes.contains(ResourceMount.getSuffix(file)) : this._compressed.booleanValue();
    }

    protected boolean doMinifyJs(String file) {
        return this._minifyJs == null ? file.endsWith(".js") : this._minifyJs.booleanValue();
    }

    protected boolean doMinifyCss(String file) {
        return this._minifyCss == null ? file.endsWith(".css") : this._minifyCss.booleanValue();
    }

    protected boolean doMerge() {
        return this._merge == null ? this._resourceSpecs.size() > 1 && this._mergedSuffixes.contains(ResourceMount.getSuffix(this._path)) : this._merge;
    }

    public ResourceMount clearSpecs() {
        this._resourceSpecs.clear();
        return this;
    }

    public Set<String> getCompressedSuffixes() {
        return this._compressedSuffixes;
    }

    public Set<String> getMergedSuffixes() {
        return this._mergedSuffixes;
    }

    protected void checkSuffixes(String path, Iterable<ResourceSpec> specs) {
        String suffix;
        if (this._suffixMismatchStrategy != SuffixMismatchStrategy.IGNORE && (suffix = ResourceMount.getSuffix(path)) != null) {
            for (ResourceSpec spec : specs) {
                if (Strings.isEqual((String)suffix, (String)ResourceMount.getSuffix(spec.getFile()))) continue;
                this.onSuffixMismatch(path, spec.getFile());
            }
        }
    }

    protected void onSuffixMismatch(String resource, String path) {
        switch (this._suffixMismatchStrategy) {
            case EXCEPTION: {
                throw new WicketRuntimeException(String.format("Suffixes don't match: %s %s", resource, path));
            }
            case WARN: {
                LOG.warn(String.format("Suffixes don't match: %s %s", resource, path));
                break;
            }
            case IGNORE: {
                break;
            }
            default: {
                throw new RuntimeException(String.format("unimplemented suffixMismatchStrategy: %s", new Object[]{this._suffixMismatchStrategy}));
            }
        }
    }

    public ResourceMount clone() {
        try {
            ResourceMount clone = (ResourceMount)super.clone();
            clone._compressedSuffixes = new HashSet<String>(this._compressedSuffixes);
            clone._mergedSuffixes = new HashSet<String>(this._mergedSuffixes);
            clone._resourceSpecs = new ArrayList<ResourceSpec>(this._resourceSpecs);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new WicketRuntimeException("clone of Object not supported?", (Throwable)e);
        }
    }

    static {
        DEFAULT_AGGRESIVE_CACHE_DURATION = DEFAULT_AGGRESSIVE_CACHE_DURATION = (int)Duration.days((int)365).seconds();
        DEFAULT_COMPRESS_SUFFIXES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("html", "css", "js", "xml")));
        DEFAULT_MERGE_SUFFIXES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("css", "js")));
        CSS_COMPRESSOR_KEY = new MetaDataKey<ICssCompressor>(){
            private static final long serialVersionUID = 1L;
        };
    }

    public static enum SuffixMismatchStrategy {
        IGNORE,
        WARN,
        EXCEPTION;

    }
}

