/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.custom.repository.config;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.custom.annotation.Custom;
import org.springframework.data.custom.mapping.CustomMappingContext;
import org.springframework.util.ClassUtils;

public class CustomMappingContextFactoryBean
extends AbstractFactoryBean<CustomMappingContext>
implements ResourceLoaderAware {
    private static final String CLASS_RESOURCE_PATTERN = "/**/*.class";
    private static final Set<TypeFilter> entityTypeFilters = new LinkedHashSet<TypeFilter>();
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private String[] basePackages;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
    }

    public Class<?> getObjectType() {
        return CustomMappingContext.class;
    }

    protected CustomMappingContext createInstance() throws Exception {
        CustomMappingContext context = new CustomMappingContext();
        context.setInitialEntitySet(this.scanPackages(this.basePackages));
        context.initialize();
        return context;
    }

    private Set<Class<?>> scanPackages(String ... packagesToScan) {
        HashSet entities = new HashSet();
        if (packagesToScan != null) {
            for (String pkg : packagesToScan) {
                try {
                    String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)pkg) + CLASS_RESOURCE_PATTERN;
                    Resource[] resources = this.resourcePatternResolver.getResources(pattern);
                    CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);
                    for (Resource resource : resources) {
                        if (!resource.isReadable()) continue;
                        MetadataReader reader = readerFactory.getMetadataReader(resource);
                        String className = reader.getClassMetadata().getClassName();
                        if (!this.matchesFilter(reader, (MetadataReaderFactory)readerFactory)) continue;
                        entities.add(ClassUtils.resolveClassName((String)className, (ClassLoader)ClassUtils.getDefaultClassLoader()));
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException("Failed to scan classpath for unlisted entity classes", ex);
                }
            }
        }
        return entities;
    }

    private boolean matchesFilter(MetadataReader reader, MetadataReaderFactory readerFactory) throws IOException {
        for (TypeFilter filter : entityTypeFilters) {
            if (!filter.match(reader, readerFactory)) continue;
            return true;
        }
        return false;
    }

    public void setResourcePatternResolver(ResourcePatternResolver resourcePatternResolver) {
        this.resourcePatternResolver = resourcePatternResolver;
    }

    public void setBasePackages(String[] basePackages) {
        this.basePackages = basePackages;
    }

    static {
        entityTypeFilters.add((TypeFilter)new AnnotationTypeFilter(Custom.class, false));
    }
}

