/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.custom.repository.support;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import lombok.NonNull;
import org.springframework.context.ApplicationContext;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;

public class CustomRepositoryQuery
implements RepositoryQuery {
    private final Method method;
    private final QueryMethod queryMethod;
    private final ApplicationContext applicationContext;

    public CustomRepositoryQuery(@NonNull Method method, @NonNull RepositoryMetadata metadata, @NonNull ApplicationContext applicationContext) {
        if (method == null) {
            throw new NullPointerException("method");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata");
        }
        if (applicationContext == null) {
            throw new NullPointerException("applicationContext");
        }
        this.method = method;
        this.queryMethod = new QueryMethod(method, metadata);
        this.applicationContext = applicationContext;
    }

    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    public Object execute(Object[] parameters) {
        try {
            return this.method.invoke(this.applicationContext.getBean(this.method.getDeclaringClass()), parameters);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException("failed to execute query " + this.method.getName(), e);
        }
    }
}

