/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.custom.repository.support;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.data.custom.annotation.Custom;
import org.springframework.data.custom.repository.CustomRepository;
import org.springframework.data.custom.repository.config.CustomMappingContextFactoryBean;
import org.springframework.data.custom.repository.support.CustomRepositoryFactoryBean;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;

public class CustomRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    public static final String CUSTOM_MAPPING_CONTEXT_BEAN_NAME = "customMappingContext";

    public String getModuleName() {
        return "Custom";
    }

    protected String getModulePrefix() {
        return "custom";
    }

    public String getRepositoryFactoryClassName() {
        return CustomRepositoryFactoryBean.class.getName();
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Collections.singleton(Custom.class);
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(CustomRepository.class);
    }

    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource config) {
        super.registerBeansForRoot(registry, config);
        Object source = config.getSource();
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(CustomMappingContextFactoryBean.class);
        builder.addPropertyValue("basePackages", (Object)config.getBasePackages());
        CustomRepositoryConfigurationExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)builder.getBeanDefinition(), (BeanDefinitionRegistry)registry, (String)CUSTOM_MAPPING_CONTEXT_BEAN_NAME, (Object)source);
    }

    public void postProcess(BeanDefinitionBuilder builder, RepositoryConfigurationSource source) {
        builder.addPropertyReference("mappingContext", CUSTOM_MAPPING_CONTEXT_BEAN_NAME);
    }
}

