/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.custom.repository.support;

import java.io.Serializable;
import org.springframework.beans.BeanUtils;
import org.springframework.data.custom.repository.support.SimpleCustomRepository;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.ReflectionEntityInformation;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;

public class CustomRepositoryFactorySupport
extends RepositoryFactorySupport {
    public <T, ID extends Serializable> EntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return new ReflectionEntityInformation(domainClass);
    }

    protected Object getTargetRepository(RepositoryInformation metadata) {
        return BeanUtils.instantiate((Class)metadata.getRepositoryBaseClass());
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleCustomRepository.class;
    }

    public <T> T getRepository(Class<T> repositoryInterface, Object customImplementation) {
        return (T)super.getRepository(repositoryInterface, customImplementation);
    }
}

