/**
 * Copyright 2016 Molindo GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.data.custom.autoconfigure;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.custom.annotation.Custom;
import org.springframework.data.custom.repository.CustomRepository;
import org.springframework.data.custom.repository.support.CustomRepositoryFactoryBean;

@Configuration
@ConditionalOnClass({ Custom.class, CustomRepository.class })
@ConditionalOnProperty(prefix = "spring.data.custom.repositories", name = "enabled", havingValue = "true", matchIfMissing = true)
@ConditionalOnMissingBean(CustomRepositoryFactoryBean.class)
@Import(CustomRepositoriesAutoConfigureRegistrar.class)
public class CustomRepositoriesAutoConfiguration {

}
